/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.util.Map;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.MaxLength;
import net.sf.oval.context.OValContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxLengthCheck
extends AbstractAnnotationCheck<MaxLength> {
    private static final long serialVersionUID = 1L;
    private int max;

    @Override
    public void configure(MaxLength constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setMax(constraintAnnotation.value());
    }

    public int getMax() {
        return this.max;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, OValContext context, Validator validator) {
        if (valueToValidate == null) {
            return true;
        }
        int len = valueToValidate.toString().length();
        return len <= this.max;
    }

    public void setMax(int max) {
        this.max = max;
        this.requireMessageVariablesRecreation();
    }

    @Override
    public Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(2);
        messageVariables.put("max", Integer.toString(this.max));
        return messageVariables;
    }
}

