/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.activitystreams.test;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaValidationTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaValidationTest.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Test
    public void testValidateToSchema() throws Exception {
        JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7);
        InputStream testActivityFolderStream = SchemaValidationTest.class.getClassLoader().getResourceAsStream("activities");
        List files = IOUtils.readLines((InputStream)testActivityFolderStream, (Charset)StandardCharsets.UTF_8);
        for (String file : files) {
            if (file.startsWith(".")) continue;
            LOGGER.debug("Test File: activities/" + file);
            String testFileString = new String(Files.readAllBytes(Paths.get("target/test-classes/activities/" + file, new String[0])));
            LOGGER.debug("Test Document JSON: " + testFileString);
            JsonNode testNode = (JsonNode)MAPPER.readValue(testFileString, ObjectNode.class);
            LOGGER.debug("Test Document Object:" + testNode);
            LOGGER.debug("Test Schema File: target/classes/verbs/" + file);
            String testSchemaString = new String(Files.readAllBytes(Paths.get("target/classes/verbs/" + file, new String[0])));
            LOGGER.debug("Test Schema JSON: " + testSchemaString);
            JsonNode testSchemaNode = (JsonNode)MAPPER.readValue(testFileString, ObjectNode.class);
            LOGGER.debug("Test Schema Object:" + testSchemaNode);
            JsonSchema testSchema = factory.getSchema(testSchemaNode);
            LOGGER.debug("Test Schema:" + testSchema);
            Set errors = testSchema.validate(testNode);
            MatcherAssert.assertThat((Object)errors.size(), (Matcher)Is.is((Object)0));
        }
    }
}

