/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.storm.trident;

import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Fields;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.core.StreamsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import storm.trident.operation.TridentCollector;
import storm.trident.spout.IBatchSpout;

public class StreamsProviderSpout
implements IBatchSpout {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamsProviderSpout.class);
    StreamsProvider provider;

    public StreamsProviderSpout(StreamsProvider provider) {
        this.provider = provider;
    }

    public void open(Map map, TopologyContext topologyContext) {
        this.provider.prepare((Object)topologyContext);
    }

    public synchronized void emitBatch(long l, TridentCollector tridentCollector) {
        List batch = IteratorUtils.toList((Iterator)this.provider.readCurrent().iterator());
        for (StreamsDatum datum : batch) {
            tridentCollector.emit((List)Lists.newArrayList((Object[])new Object[]{datum.getTimestamp(), datum.getSequenceid(), datum.getDocument()}));
        }
    }

    public void ack(long l) {
    }

    public void close() {
        this.provider.cleanUp();
    }

    public Map getComponentConfiguration() {
        return null;
    }

    public Fields getOutputFields() {
        return new Fields(new String[]{"timestamp", "sequenceid", "document"});
    }
}

