/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.storm.trident;

import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.core.StreamsProcessor;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import storm.trident.operation.Function;
import storm.trident.operation.TridentCollector;
import storm.trident.operation.TridentOperationContext;
import storm.trident.tuple.TridentTuple;

public class StreamsProcessorFunction
implements Function {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamsProcessorFunction.class);
    StreamsProcessor processor;

    public void execute(TridentTuple objects, TridentCollector tridentCollector) {
        StreamsDatum datum = new StreamsDatum(objects.getValueByField("document"), new DateTime((Object)objects.getLongByField("timestamp")), new BigInteger(objects.getStringByField("sequenceid")));
        List results = this.processor.process(datum);
        for (StreamsDatum result : results) {
            tridentCollector.emit((List)Lists.newArrayList((Object[])new Object[]{datum.getTimestamp(), datum.getSequenceid(), datum.getDocument()}));
        }
    }

    public void prepare(Map map, TridentOperationContext tridentOperationContext) {
        this.processor.prepare((Object)map);
    }

    public void cleanup() {
        this.processor.cleanUp();
    }
}

