/*
 * Decompiled with CFR 0.152.
 */
package com.sysomos.test;

import com.fasterxml.aalto.stax.InputFactoryImpl;
import com.fasterxml.aalto.stax.OutputFactoryImpl;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.sysomos.xml.BeatApi;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysomosXmlSerDeIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(SysomosXmlSerDeIT.class);
    private XmlMapper xmlMapper;

    @Before
    public void before() {
        XmlFactory xmlFactory = new XmlFactory((XMLInputFactory)new InputFactoryImpl(), (XMLOutputFactory)new OutputFactoryImpl());
        JacksonXmlModule module = new JacksonXmlModule();
        module.setDefaultUseWrapper(false);
        this.xmlMapper = new XmlMapper(xmlFactory, module);
        this.xmlMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, Boolean.TRUE.booleanValue());
        this.xmlMapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, Boolean.TRUE.booleanValue());
        this.xmlMapper.configure(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY, Boolean.TRUE.booleanValue());
        this.xmlMapper.configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, Boolean.TRUE.booleanValue());
    }

    @Test
    public void test() {
        InputStream is = SysomosXmlSerDeIT.class.getResourceAsStream("/sysomos_xmls.txt");
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        try {
            while (br.ready()) {
                String line = br.readLine();
                LOGGER.debug(line);
                BeatApi ser = (BeatApi)this.xmlMapper.readValue(line, BeatApi.class);
                String des = this.xmlMapper.writeValueAsString((Object)ser);
                LOGGER.debug(des);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail();
        }
    }
}

