/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.urls;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.jackson.StreamsJacksonMapper;
import org.apache.streams.pojo.json.Activity;
import org.apache.streams.urls.LinkDetails;
import org.apache.streams.urls.LinkResolver;
import org.apache.streams.urls.LinkResolverHelperFunctions;
import org.apache.streams.urls.LinkResolverProcessor;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestLinkUnwinderProcessor {
    private static String activityString;

    @Test
    public void testLinkUnwinderBadDomain() {
        LinkResolver resolver = new LinkResolver("http://nope@#$%");
        resolver.run();
        LinkDetails details = resolver.getLinkDetails();
        Assert.assertEquals((String)"Should be 400", (Object)LinkDetails.LinkStatus.MALFORMED_URL, (Object)details.getLinkStatus());
    }

    @Ignore
    @Test
    public void testLinkResolverSerializability() {
        LinkResolver resolver = new LinkResolver("http://bit.ly/1cX5Rh4");
        LinkResolver clone = (LinkResolver)SerializationUtils.clone((Serializable)resolver);
    }

    @Ignore
    @Test
    public void test404Link() {
        LinkResolver resolver = new LinkResolver("http://www.kneesupmotherbrown.me/2013/05/26/well-its-fair-to-say-may-has-been-a-crappy-month");
        resolver.run();
        LinkDetails details = resolver.getLinkDetails();
        Assert.assertEquals((String)"Should be 404", (Object)LinkDetails.LinkStatus.NOT_FOUND, (Object)details.getLinkStatus());
    }

    @Test
    public void testLinkResolverProcessorSerializability() {
        LinkResolverProcessor processor = new LinkResolverProcessor();
        LinkResolverProcessor clone = (LinkResolverProcessor)SerializationUtils.clone((Serializable)processor);
    }

    @Ignore
    @Test
    public void testActivityLinkUnwinderProcessorBitly() throws Exception {
        this.testActivityUnwinderHelper(Collections.singletonList("http://bit.ly/1cX5Rh4"), Collections.singletonList("http://www.wcgworld.com/"));
        this.testStringActivityUnwinderHelper(Collections.singletonList("http://bit.ly/1cX5Rh4"), Collections.singletonList("http://www.wcgworld.com/"));
    }

    @Ignore
    @Test
    public void testActivityLinkUnwinderProcessorTdotCo() throws Exception {
        this.testActivityUnwinderHelper(Collections.singletonList("http://t.co/lLFgFynv2G"), Collections.singletonList("http://www.holmesreport.com/latest"));
        this.testStringActivityUnwinderHelper(Collections.singletonList("http://t.co/lLFgFynv2G"), Collections.singletonList("http://www.holmesreport.com/latest"));
    }

    @Ignore
    @Test
    public void testActivityLinkUnwinderProcessorGoogle() throws Exception {
        this.testActivityUnwinderHelper(Collections.singletonList("http://goo.gl/wSrHDA"), Collections.singletonList("http://www.wcgworld.com/"));
        this.testStringActivityUnwinderHelper(Collections.singletonList("http://goo.gl/wSrHDA"), Collections.singletonList("http://www.wcgworld.com/"));
    }

    @Ignore
    @Test
    public void testActivityLinkUnwinderProcessorOwly() throws Exception {
        this.testActivityUnwinderHelper(Collections.singletonList("http://ow.ly/u4Kte"), Collections.singletonList("http://www.wcgworld.com/"));
        this.testStringActivityUnwinderHelper(Collections.singletonList("http://ow.ly/u4Kte"), Collections.singletonList("http://www.wcgworld.com/"));
    }

    @Ignore
    @Test
    public void testActivityLinkUnwinderProcessorGoDaddy() throws Exception {
        this.testActivityUnwinderHelper(Collections.singletonList("http://x.co/3yapt"), Collections.singletonList("http://www.wcgworld.com/"));
        this.testStringActivityUnwinderHelper(Collections.singletonList("http://x.co/3yapt"), Collections.singletonList("http://www.wcgworld.com/"));
    }

    @Ignore
    @Test
    public void testActivityLinkUnwinderProcessorMulti() throws Exception {
        this.testActivityUnwinderHelper(Arrays.asList("http://x.co/3yapt", "http://ow.ly/u4Kte", "http://goo.gl/wSrHDA"), Collections.singletonList("http://www.wcgworld.com/"));
        this.testStringActivityUnwinderHelper(Arrays.asList("http://x.co/3yapt", "http://ow.ly/u4Kte", "http://goo.gl/wSrHDA"), Collections.singletonList("http://www.wcgworld.com/"));
    }

    public void testActivityUnwinderHelper(List<String> input, List<String> expected) throws Exception {
        LinkResolverHelperFunctions.purgeAllDomainWaitTimes();
        Activity activity = new Activity();
        activity.setLinks(input);
        StreamsDatum datum = new StreamsDatum((Object)activity);
        LinkResolverProcessor processor = new LinkResolverProcessor();
        processor.prepare(null);
        List result = processor.process(datum);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        StreamsDatum resultDatum = (StreamsDatum)result.get(0);
        Assert.assertNotNull((Object)resultDatum);
        Assert.assertTrue((boolean)(resultDatum.getDocument() instanceof Activity));
        Activity resultActivity = (Activity)resultDatum.getDocument();
        Assert.assertNotNull((Object)resultActivity.getLinks());
        List resultLinks = resultActivity.getLinks();
        Assert.assertEquals((long)expected.size(), (long)resultLinks.size());
        Assert.assertEquals(expected, (Object)resultLinks);
    }

    public void testStringActivityUnwinderHelper(List<String> input, List<String> expected) throws Exception {
        LinkResolverHelperFunctions.purgeAllDomainWaitTimes();
        Activity activity = new Activity();
        activity.setLinks(input);
        String str = StreamsJacksonMapper.getInstance().writeValueAsString((Object)activity);
        StreamsDatum datum = new StreamsDatum((Object)str);
        LinkResolverProcessor processor = new LinkResolverProcessor();
        processor.prepare(null);
        List result = processor.process(datum);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        StreamsDatum resultDatum = (StreamsDatum)result.get(0);
        Assert.assertNotNull((Object)resultDatum);
        Assert.assertTrue((boolean)(resultDatum.getDocument() instanceof String));
        String resultActivityString = (String)resultDatum.getDocument();
        Activity resultActivity = (Activity)StreamsJacksonMapper.getInstance().readValue(resultActivityString, Activity.class);
        Assert.assertNotNull((Object)resultActivity.getLinks());
        List resultLinks = resultActivity.getLinks();
        Assert.assertEquals((long)expected.size(), (long)resultLinks.size());
        Assert.assertEquals(expected, (Object)resultLinks);
    }
}

