/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.urls;

import java.util.Date;
import org.apache.streams.urls.LinkResolverHelperFunctions;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkHelperFunctionsTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkHelperFunctionsTest.class);

    @Test
    public void testIsURL() {
        Assert.assertTrue((boolean)LinkResolverHelperFunctions.isURL((String)"http://goo.gl/wSrHDA"));
        Assert.assertTrue((boolean)LinkResolverHelperFunctions.isURL((String)"http://ow.ly/u4Kte"));
        Assert.assertTrue((boolean)LinkResolverHelperFunctions.isURL((String)"http://x.co/3yapt"));
        Assert.assertTrue((boolean)LinkResolverHelperFunctions.isURL((String)"http://bit.ly/1cX5Rh4"));
        Assert.assertTrue((boolean)LinkResolverHelperFunctions.isURL((String)"http://t.co/oP8JYB0MYW"));
        Assert.assertTrue((boolean)LinkResolverHelperFunctions.isURL((String)"http://goo.gl/wSrHDA"));
        Assert.assertTrue((boolean)LinkResolverHelperFunctions.isURL((String)"http://t.co/fBoCby3l1t"));
        Assert.assertTrue((boolean)LinkResolverHelperFunctions.isURL((String)"http://paper.li/GuyKawasaki"));
        Assert.assertTrue((boolean)LinkResolverHelperFunctions.isURL((String)"http://www.google.com"));
        Assert.assertTrue((boolean)LinkResolverHelperFunctions.isURL((String)"http://goo.gl/wSrHDA"));
        Assert.assertTrue((boolean)LinkResolverHelperFunctions.isURL((String)"http://www.cnn.com"));
    }

    @Test
    public void testContainsURL() {
        Assert.assertTrue((boolean)LinkResolverHelperFunctions.containsURLs((String)"here is the URL: http://goo.gl/wSrHDA"));
        Assert.assertTrue((boolean)LinkResolverHelperFunctions.containsURLs((String)"a lovely day for URLing it up http://ow.ly/u4Kte"));
        Assert.assertTrue((boolean)LinkResolverHelperFunctions.containsURLs((String)"http://x.co/3yapt is really cool"));
        Assert.assertTrue((boolean)LinkResolverHelperFunctions.containsURLs((String)"http://bit.ly/1cX5Rh4 me likes"));
        Assert.assertTrue((boolean)LinkResolverHelperFunctions.containsURLs((String)"http://t.co/oP8JYB0MYW wtf mate?"));
        Assert.assertTrue((boolean)LinkResolverHelperFunctions.containsURLs((String)"Every morning is a good morning in URL world: http://goo.gl/wSrHDA"));
        Assert.assertFalse((boolean)LinkResolverHelperFunctions.containsURLs((String)"Every day I awake, only to find, I have no URLS"));
        Assert.assertFalse((boolean)LinkResolverHelperFunctions.containsURLs((String)"Http:// to be or not to be"));
        Assert.assertFalse((boolean)LinkResolverHelperFunctions.containsURLs((String)"Can I get an http://X up on the board pat?"));
        Assert.assertFalse((boolean)LinkResolverHelperFunctions.containsURLs((String)"You must remember Joey, no matter how much you ftp://stink you must never, EVER, take a shower in my dressing room!"));
    }

    @Test
    public void testSimple() {
        LinkResolverHelperFunctions.purgeAllDomainWaitTimes();
        String domain1 = "smashew.com";
        Assert.assertEquals((String)"smashew.com: No need to wait", (long)0L, (long)LinkResolverHelperFunctions.waitTimeForDomain((String)domain1));
        long smashewSleepTime1 = LinkResolverHelperFunctions.waitTimeForDomain((String)domain1);
        LOGGER.debug("Sleeping: " + new Date().getTime() + "-" + smashewSleepTime1);
        LinkHelperFunctionsTest.safeSleep(smashewSleepTime1);
        LOGGER.debug("Slept For: " + new Date().getTime() + "-" + smashewSleepTime1);
        Assert.assertEquals((String)"smashew.com: No need to wait", (long)0L, (long)LinkResolverHelperFunctions.waitTimeForDomain((String)domain1));
    }

    private static void safeSleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSingle() {
        LinkResolverHelperFunctions.purgeAllDomainWaitTimes();
        String domain1 = "smashew.com";
        String domain2 = "google.com";
        long smashewSleepTime1 = LinkResolverHelperFunctions.waitTimeForDomain((String)domain1);
        long smashewSleepTime2 = LinkResolverHelperFunctions.waitTimeForDomain((String)domain1);
        long smashewSleepTime3 = LinkResolverHelperFunctions.waitTimeForDomain((String)domain1);
        long smashewSleepTime4 = LinkResolverHelperFunctions.waitTimeForDomain((String)domain1);
        LOGGER.debug("smashew.com: " + smashewSleepTime1 + "," + smashewSleepTime2 + "," + smashewSleepTime3 + "," + smashewSleepTime4);
        Assert.assertEquals((String)"smashew.com: No need to wait", (long)0L, (long)smashewSleepTime1);
        Assert.assertTrue((String)"smashew.com: Wait for at least min x 1", (smashewSleepTime2 >= 900L ? 1 : 0) != 0);
        Assert.assertTrue((String)"smashew.com: Wait for at least min x 2", (smashewSleepTime3 >= 1800L ? 1 : 0) != 0);
        Assert.assertTrue((String)"smashew.com: Wait for at least min x 3", (smashewSleepTime4 >= 2700L ? 1 : 0) != 0);
        long timeBeforeSleep = new Date().getTime();
        LOGGER.debug("Sleeping for: " + smashewSleepTime4 + " ms");
        LinkHelperFunctionsTest.safeSleep(smashewSleepTime4);
        LOGGER.debug("Actually slept for: " + (new Date().getTime() - timeBeforeSleep) + " ms");
        long postSleepDomain1 = LinkResolverHelperFunctions.waitTimeForDomain((String)domain1);
        LOGGER.debug("smashew.com: Post Sleep domain1: " + postSleepDomain1);
        Assert.assertEquals((String)"Smashew.com: No need to wait after sleep", (long)0L, (long)postSleepDomain1);
    }

    @Test
    public void testMulti() {
        LinkResolverHelperFunctions.purgeAllDomainWaitTimes();
        String domain1 = "smashew.com";
        String domain2 = "google.com";
        long smashewSleepTime1 = LinkResolverHelperFunctions.waitTimeForDomain((String)domain1);
        long smashewSleepTime2 = LinkResolverHelperFunctions.waitTimeForDomain((String)domain1);
        long smashewSleepTime3 = LinkResolverHelperFunctions.waitTimeForDomain((String)domain1);
        long googleSleepTime1 = LinkResolverHelperFunctions.waitTimeForDomain((String)domain2);
        long googleSleepTime2 = LinkResolverHelperFunctions.waitTimeForDomain((String)domain2);
        LOGGER.debug("smashew.com: " + smashewSleepTime1 + "," + smashewSleepTime2 + "," + smashewSleepTime3);
        LOGGER.debug("google.com: " + googleSleepTime1 + "," + googleSleepTime2);
        Assert.assertEquals((String)"smashew.com: No need to wait", (long)0L, (long)smashewSleepTime1);
        Assert.assertTrue((String)"smashew.com: Wait for at least min x 1", (smashewSleepTime2 >= 900L ? 1 : 0) != 0);
        Assert.assertTrue((String)"smashew.com: Wait for at least min x 2", (smashewSleepTime3 >= 1800L ? 1 : 0) != 0);
        Assert.assertEquals((String)"google.com: No need to wait", (long)0L, (long)googleSleepTime1);
        Assert.assertTrue((String)"google.com: No need to wait", (googleSleepTime2 >= 900L ? 1 : 0) != 0);
        try {
            LOGGER.debug("WAITING FOR: " + smashewSleepTime3);
            Thread.sleep(smashewSleepTime3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        long postSleepDomain1 = LinkResolverHelperFunctions.waitTimeForDomain((String)domain1);
        long postSleepDomain2 = LinkResolverHelperFunctions.waitTimeForDomain((String)domain2);
        LOGGER.debug("smashew.com: Post Sleep domain1: " + postSleepDomain1);
        LOGGER.debug("google.com:  Post Sleep domain2: " + postSleepDomain2);
        Assert.assertEquals((String)"Smashew.com: No need to wait after sleep", (long)0L, (long)postSleepDomain1);
        Assert.assertEquals((String)"google.com: No need to wait after sleep", (long)0L, (long)postSleepDomain2);
    }
}

