/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.urls;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.core.StreamsProcessor;
import org.apache.streams.jackson.StreamsJacksonMapper;
import org.apache.streams.pojo.json.Activity;
import org.apache.streams.urls.LinkResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkResolverProcessor
implements StreamsProcessor {
    private static final String STREAMS_ID = "LinkResolverProcessor";
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkResolverProcessor.class);
    private static ObjectMapper mapper = StreamsJacksonMapper.getInstance();

    public String getId() {
        return STREAMS_ID;
    }

    public List<StreamsDatum> process(StreamsDatum entry) {
        ArrayList result = Lists.newArrayList();
        LOGGER.debug("{} processing {}", (Object)STREAMS_ID, entry.getDocument().getClass());
        if (entry.getDocument() instanceof Activity) {
            Activity activity = (Activity)entry.getDocument();
            activity.setLinks((List)Lists.newArrayList(this.unwind(activity.getLinks())));
            entry.setDocument((Object)activity);
            result.add(entry);
            return result;
        }
        if (entry.getDocument() instanceof String) {
            Activity activity;
            try {
                activity = (Activity)mapper.readValue((String)entry.getDocument(), Activity.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.warn(e.getMessage());
                return Lists.newArrayList((Object[])new StreamsDatum[]{entry});
            }
            activity.setLinks((List)Lists.newArrayList(this.unwind(activity.getLinks())));
            try {
                entry.setDocument((Object)mapper.writeValueAsString((Object)activity));
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.warn(e.getMessage());
                return Lists.newArrayList();
            }
            result.add(entry);
            return result;
        }
        return Lists.newArrayList();
    }

    public void prepare(Object o) {
    }

    public void cleanUp() {
    }

    protected Set<String> unwind(List<String> inputLinks) {
        HashSet<String> outputLinks = new HashSet<String>();
        for (String link : inputLinks) {
            try {
                LinkResolver unwinder = new LinkResolver(link);
                unwinder.run();
                outputLinks.add(unwinder.getLinkDetails().getFinalURL());
            }
            catch (Exception e) {
                LOGGER.debug("Failed to unwind link : {}", (Object)link);
                LOGGER.debug("Exception unwinding link : {}", (Throwable)e);
                e.printStackTrace();
            }
        }
        return outputLinks;
    }
}

