/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.urls;

import java.util.Date;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;

public final class LinkResolverHelperFunctions {
    private static final String REGEX_URL = "(?:(?:https?|ftp)://)(?:\\S+(?::\\S*)?@)?(?:(?!(?:10|127)(?:\\.\\d{1,3}){3})(?!(?:169\\.254|192\\.168)(?:\\.\\d{1,3}){2})(?!172\\.(?:1[6-9]|2\\d|3[0-1])(?:\\.\\d{1,3}){2})(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}(?:\\.(?:[1-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4]))|(?:(?:[a-z\\u00a1-\\uffff0-9]+-?)*[a-z\\u00a1-\\uffff0-9]+)(?:\\.(?:[a-z\\u00a1-\\uffff0-9]+-?)*[a-z\\u00a1-\\uffff0-9]+)*(?:\\.(?:[a-z\\u00a1-\\uffff]{2,})))(?::\\d{2,5})?(?:/[^\\s]*)?";
    private static final String REGEX_URL_EXPLICIT = "^(?:(?:https?|ftp)://)(?:\\S+(?::\\S*)?@)?(?:(?!(?:10|127)(?:\\.\\d{1,3}){3})(?!(?:169\\.254|192\\.168)(?:\\.\\d{1,3}){2})(?!172\\.(?:1[6-9]|2\\d|3[0-1])(?:\\.\\d{1,3}){2})(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}(?:\\.(?:[1-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4]))|(?:(?:[a-z\\u00a1-\\uffff0-9]+-?)*[a-z\\u00a1-\\uffff0-9]+)(?:\\.(?:[a-z\\u00a1-\\uffff0-9]+-?)*[a-z\\u00a1-\\uffff0-9]+)*(?:\\.(?:[a-z\\u00a1-\\uffff]{2,})))(?::\\d{2,5})?(?:/[^\\s]*)?$";
    public static final long RECENT_DOMAINS_BACKOFF = 1000L;
    public static final long DEFAULT_STAGGER = 100L;
    private static final ConcurrentMap<String, Date> RECENT_DOMAINS = new ConcurrentHashMap<String, Date>();
    private static Timer timer;

    public static boolean isURL(String possibleURL) {
        return possibleURL.matches(REGEX_URL_EXPLICIT);
    }

    public static boolean containsURLs(String possiblyHasURLs) {
        return possiblyHasURLs != null && Pattern.compile(REGEX_URL).matcher(possiblyHasURLs).find();
    }

    private LinkResolverHelperFunctions() {
    }

    public static void purgeAllDomainWaitTimes() {
        RECENT_DOMAINS.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long waitTimeForDomain(String domain) {
        domain = domain.toLowerCase();
        long toReturn = 0L;
        Class<LinkResolverHelperFunctions> clazz = LinkResolverHelperFunctions.class;
        synchronized (LinkResolverHelperFunctions.class) {
            LinkResolverHelperFunctions.purgeAnyExpiredDomains();
            if (timer == null) {
                LinkResolverHelperFunctions.setupTimer();
            }
            long currentTime = new Date().getTime();
            if (RECENT_DOMAINS.containsKey(domain)) {
                long nextTime = ((Date)RECENT_DOMAINS.get(domain)).getTime();
                long random = (long)(Math.random() * 200.0);
                if (currentTime >= nextTime) {
                    RECENT_DOMAINS.put(domain, new Date(currentTime + 1000L));
                } else {
                    toReturn = nextTime - currentTime + 1000L;
                    RECENT_DOMAINS.put(domain, new Date(currentTime + toReturn));
                    toReturn += random + 1L;
                }
            } else {
                RECENT_DOMAINS.put(domain, new Date(currentTime + 1000L));
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return toReturn;
        }
    }

    private static void setupTimer() {
        timer = new Timer(true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                LinkResolverHelperFunctions.purgeAnyExpiredDomains();
            }
        }, 2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void purgeAnyExpiredDomains() {
        Class<LinkResolverHelperFunctions> clazz = LinkResolverHelperFunctions.class;
        synchronized (LinkResolverHelperFunctions.class) {
            long currentTime = new Date().getTime();
            if (RECENT_DOMAINS.size() != 0) {
                HashSet<String> ableToRemove = new HashSet<String>();
                for (String k : RECENT_DOMAINS.keySet()) {
                    if (currentTime < ((Date)RECENT_DOMAINS.get(k)).getTime()) continue;
                    ableToRemove.add(k);
                }
                if (ableToRemove.size() > 0) {
                    for (String k : ableToRemove) {
                        RECENT_DOMAINS.remove(k);
                    }
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

