/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.urls;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.streams.urls.LinkDetails;
import org.apache.streams.urls.LinkResolverHelperFunctions;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkResolver
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkResolver.class);
    private static final int MAX_ALLOWED_REDIRECTS = 30;
    private static final int DEFAULT_HTTP_TIMEOUT = 10000;
    private static final String LOCATION_IDENTIFIER = "location";
    private static final String SET_COOKIE_IDENTIFIER = "set-cookie";
    private static final Map<String, String> SPOOF_HTTP_HEADERS = new HashMap<String, String>(){
        {
            this.put("Connection", "Keep-Alive");
            this.put("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/31.0.1650.48 Safari/537.36");
            this.put("Accept-Language", "en-US,en;q=0.8,zh;q=0.6");
        }
    };
    private static final Collection<String> BOTS_ARE_OK = new ArrayList<String>(){
        {
            this.add("t.co");
        }
    };
    private static final Collection<String> URL_TRACKING_TO_REMOVE = new ArrayList<String>(){
        {
            this.add("([\\?&])utm_source(=)[^&?]*");
            this.add("([\\?&])utm_medium(=)[^&?]*");
            this.add("([\\?&])utm_term(=)[^&?]*");
            this.add("([\\?&])utm_content(=)[^&?]*");
            this.add("([\\?&])utm_campaign(=)[^&?]*");
        }
    };
    private final LinkDetails linkDetails;
    private Collection<String> domainsSensitiveTo = new HashSet<String>();

    public LinkDetails getLinkDetails() {
        return this.linkDetails;
    }

    public LinkResolver(String originalURL) {
        this.linkDetails = new LinkDetails();
        this.linkDetails.setOriginalURL(originalURL);
    }

    public void run() {
        Preconditions.checkNotNull((Object)this.linkDetails.getOriginalURL());
        this.linkDetails.setStartTime(DateTime.now());
        for (int i = 0; i < 3 && this.linkDetails.getFinalURL() == null; ++i) {
            if (this.linkDetails.getLinkStatus() == LinkDetails.LinkStatus.SUCCESS) continue;
            this.unwindLink(this.linkDetails.getOriginalURL());
        }
        if (this.linkDetails.getRedirectCount() == 0L || this.linkDetails.getRedirected() == null) {
            this.linkDetails.setRedirected(false);
        }
        this.linkDetails.setFinalURL(this.cleanURL(this.linkDetails.getFinalURL()));
        if (!Strings.isNullOrEmpty((String)this.linkDetails.getFinalURL())) {
            this.linkDetails.setNormalizedURL(LinkResolver.normalizeURL(this.linkDetails.getFinalURL()));
        }
        if (!Strings.isNullOrEmpty((String)this.linkDetails.getNormalizedURL())) {
            this.linkDetails.setUrlParts(LinkResolver.tokenizeURL(this.linkDetails.getNormalizedURL()));
        }
        this.updateTookInMillis();
    }

    protected void updateTookInMillis() {
        Preconditions.checkNotNull((Object)this.linkDetails.getStartTime());
        this.linkDetails.setTookInMills(DateTime.now().minus(this.linkDetails.getStartTime().getMillis()).getMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void unwindLink(String url) {
        Preconditions.checkNotNull((Object)this.linkDetails);
        Preconditions.checkNotNull((Object)url);
        urlValidator = new UrlValidator();
        if (!urlValidator.isValid(url)) {
            this.linkDetails.setLinkStatus(LinkDetails.LinkStatus.MALFORMED_URL);
            return;
        }
        if (this.linkDetails.getRedirectCount() != null && this.linkDetails.getRedirectCount() > 0L && (this.linkDetails.getOriginalURL().equals(url) || this.linkDetails.getRedirects().contains(url)) || this.linkDetails.getRedirectCount() != null && this.linkDetails.getRedirectCount() > 30L) {
            this.linkDetails.setLinkStatus(LinkDetails.LinkStatus.LOOP);
            return;
        }
        if (!this.linkDetails.getOriginalURL().equals(url)) {
            this.linkDetails.getRedirects().add(url);
        }
        connection = null;
        reDirectedLink = null;
        try {
            thisURL = new URL(url);
            try {
                host = thisURL.getHost().toLowerCase();
                if (!this.domainsSensitiveTo.contains(host)) {
                    this.domainsSensitiveTo.add((String)host);
                    domainWait = LinkResolverHelperFunctions.waitTimeForDomain(thisURL.getHost());
                    if (domainWait > 0L) {
                        LinkResolver.LOGGER.debug("Waiting for domain: {}", (Object)domainWait);
                        Thread.sleep(domainWait);
                    }
                }
            }
            catch (Exception host) {
                // empty catch block
            }
            connection = (HttpURLConnection)new URL(url).openConnection();
            if (!LinkResolver.BOTS_ARE_OK.contains(thisURL.getHost())) {
                connection.addRequestProperty("Host", thisURL.getHost());
                for (String k : LinkResolver.SPOOF_HTTP_HEADERS.keySet()) {
                    connection.addRequestProperty(k, LinkResolver.SPOOF_HTTP_HEADERS.get(k));
                }
                if (this.linkDetails.getRedirectCount() > 0L && LinkResolver.BOTS_ARE_OK.contains(thisURL.getHost())) {
                    connection.addRequestProperty("Referrer", this.linkDetails.getOriginalURL());
                }
            }
            connection.setReadTimeout(10000);
            connection.setConnectTimeout(10000);
            connection.setInstanceFollowRedirects(false);
            if (this.linkDetails.getCookies() != null) {
                for (String cookie : this.linkDetails.getCookies()) {
                    connection.addRequestProperty("Cookie", cookie.split(";", 1)[0]);
                }
            }
            connection.connect();
            this.linkDetails.setFinalResponseCode(Long.valueOf(connection.getResponseCode()));
            headers = this.createCaseInsensitiveMap(connection.getHeaderFields());
            if (headers.containsKey("set-cookie")) {
                this.linkDetails.getCookies().add(headers.get("set-cookie").get(0));
            }
            switch (this.linkDetails.getFinalResponseCode().intValue()) {
                case 200: {
                    this.linkDetails.setFinalURL(connection.getURL().toString());
                    this.linkDetails.setDomain(new URL(this.linkDetails.getFinalURL()).getHost());
                    this.linkDetails.setLinkStatus(LinkDetails.LinkStatus.SUCCESS);
                    ** break;
lbl58:
                    // 1 sources

                    break;
                }
                case 300: 
                case 301: 
                case 302: 
                case 303: 
                case 304: 
                case 306: 
                case 307: {
                    if (!this.linkDetails.getOriginalURL().toLowerCase().equals(connection.getURL().toString().toLowerCase())) {
                        this.linkDetails.setFinalURL(connection.getURL().toString());
                    }
                    if (!headers.containsKey("location")) {
                        LinkResolver.LOGGER.info("Headers: {}", headers);
                        this.linkDetails.setLinkStatus(LinkDetails.LinkStatus.REDIRECT_ERROR);
                        ** break;
lbl66:
                        // 1 sources

                    } else {
                        this.linkDetails.setRedirected(Boolean.TRUE);
                        this.linkDetails.setRedirectCount(this.linkDetails.getRedirectCount() + 1L);
                        reDirectedLink = connection.getHeaderField("location");
                        ** break;
                    }
lbl71:
                    // 1 sources

                    break;
                }
                case 305: {
                    ** break;
lbl74:
                    // 1 sources

                    break;
                }
                case 401: {
                    this.linkDetails.setLinkStatus(LinkDetails.LinkStatus.UNAUTHORIZED);
                    ** break;
lbl78:
                    // 1 sources

                    break;
                }
                case 403: {
                    this.linkDetails.setLinkStatus(LinkDetails.LinkStatus.FORBIDDEN);
                    ** break;
lbl82:
                    // 1 sources

                    break;
                }
                case 404: {
                    this.linkDetails.setLinkStatus(LinkDetails.LinkStatus.NOT_FOUND);
                    ** break;
lbl86:
                    // 1 sources

                    break;
                }
                case 500: 
                case 501: 
                case 502: 
                case 503: 
                case 504: 
                case 505: {
                    this.linkDetails.setLinkStatus(LinkDetails.LinkStatus.HTTP_ERROR_STATUS);
                    ** break;
lbl90:
                    // 1 sources

                    break;
                }
                default: {
                    LinkResolver.LOGGER.info("Unrecognized HTTP Response Code: {}", (Object)this.linkDetails.getFinalResponseCode());
                    this.linkDetails.setLinkStatus(LinkDetails.LinkStatus.NOT_FOUND);
                    break;
                }
            }
        }
        catch (MalformedURLException e) {
            this.linkDetails.setLinkStatus(LinkDetails.LinkStatus.MALFORMED_URL);
        }
        catch (IOException ex) {
            this.linkDetails.setLinkStatus(LinkDetails.LinkStatus.ERROR);
        }
        catch (Exception ex) {
            this.linkDetails.setLinkStatus(LinkDetails.LinkStatus.EXCEPTION);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        if (reDirectedLink != null) {
            this.unwindLink(reDirectedLink);
        }
    }

    private Map<String, List<String>> createCaseInsensitiveMap(Map<String, List<String>> input) {
        HashMap<String, List<String>> toReturn = new HashMap<String, List<String>>();
        for (String k : input.keySet()) {
            if (k == null || input.get(k) == null) continue;
            toReturn.put(k.toLowerCase(), input.get(k));
        }
        return toReturn;
    }

    private String cleanURL(String url) {
        if (url == null) {
            return null;
        }
        int startLength = url.length();
        for (String pattern : URL_TRACKING_TO_REMOVE) {
            url = url.replaceAll(pattern, "");
        }
        if (url.length() < startLength) {
            this.linkDetails.setTracked(Boolean.TRUE);
        }
        return url;
    }

    public static String normalizeURL(String url) {
        String normalizedUrl = url;
        try {
            URLCodec codec = new URLCodec();
            normalizedUrl = codec.decode(url);
            if (normalizedUrl.contains("://")) {
                normalizedUrl = normalizedUrl.split(":/{2}")[1];
            }
        }
        catch (NullPointerException npe) {
            System.err.println("NPE Decoding URL. Decoding skipped.");
            npe.printStackTrace();
        }
        catch (Throwable e) {
            System.err.println("Misc error Decoding URL. Decoding skipped.");
            e.printStackTrace();
        }
        return normalizedUrl;
    }

    public static List<String> tokenizeURL(String url) {
        url = LinkResolver.normalizeURL(url);
        ArrayList<String> toReturn = new ArrayList<String>();
        for (String part : url.split("/+")) {
            toReturn.add(part.toLowerCase());
        }
        return toReturn;
    }
}

