/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.urls;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"linkStatus", "originalURL", "finalURL", "normalizedURL", "urlParts", "domain", "redirected", "redirects", "redirectCount", "tracked", "finalResponseCode", "cookies", "startTime", "tookInMills"})
public class LinkDetails
implements Serializable {
    @JsonProperty(value="linkStatus")
    private LinkStatus linkStatus;
    @JsonProperty(value="originalURL")
    private String originalURL;
    @JsonProperty(value="finalURL")
    private String finalURL;
    @JsonProperty(value="normalizedURL")
    private String normalizedURL;
    @JsonProperty(value="urlParts")
    private List<String> urlParts = new ArrayList<String>();
    @JsonProperty(value="domain")
    private String domain;
    @JsonProperty(value="redirected")
    private Boolean redirected;
    @JsonProperty(value="redirects")
    private List<String> redirects = new ArrayList<String>();
    @JsonProperty(value="redirectCount")
    private Long redirectCount = 0L;
    @JsonProperty(value="tracked")
    private Boolean tracked;
    @JsonProperty(value="finalResponseCode")
    private Long finalResponseCode;
    @JsonProperty(value="cookies")
    @JsonDeserialize(as=LinkedHashSet.class)
    private Set<String> cookies = new LinkedHashSet<String>();
    @JsonProperty(value="startTime")
    private DateTime startTime;
    @JsonProperty(value="tookInMills")
    private Long tookInMills;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="linkStatus")
    public LinkStatus getLinkStatus() {
        return this.linkStatus;
    }

    @JsonProperty(value="linkStatus")
    public void setLinkStatus(LinkStatus linkStatus) {
        this.linkStatus = linkStatus;
    }

    public LinkDetails withLinkStatus(LinkStatus linkStatus) {
        this.linkStatus = linkStatus;
        return this;
    }

    @JsonProperty(value="originalURL")
    public String getOriginalURL() {
        return this.originalURL;
    }

    @JsonProperty(value="originalURL")
    public void setOriginalURL(String originalURL) {
        this.originalURL = originalURL;
    }

    public LinkDetails withOriginalURL(String originalURL) {
        this.originalURL = originalURL;
        return this;
    }

    @JsonProperty(value="finalURL")
    public String getFinalURL() {
        return this.finalURL;
    }

    @JsonProperty(value="finalURL")
    public void setFinalURL(String finalURL) {
        this.finalURL = finalURL;
    }

    public LinkDetails withFinalURL(String finalURL) {
        this.finalURL = finalURL;
        return this;
    }

    @JsonProperty(value="normalizedURL")
    public String getNormalizedURL() {
        return this.normalizedURL;
    }

    @JsonProperty(value="normalizedURL")
    public void setNormalizedURL(String normalizedURL) {
        this.normalizedURL = normalizedURL;
    }

    public LinkDetails withNormalizedURL(String normalizedURL) {
        this.normalizedURL = normalizedURL;
        return this;
    }

    @JsonProperty(value="urlParts")
    public List<String> getUrlParts() {
        return this.urlParts;
    }

    @JsonProperty(value="urlParts")
    public void setUrlParts(List<String> urlParts) {
        this.urlParts = urlParts;
    }

    public LinkDetails withUrlParts(List<String> urlParts) {
        this.urlParts = urlParts;
        return this;
    }

    @JsonProperty(value="domain")
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public LinkDetails withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    @JsonProperty(value="redirected")
    public Boolean getRedirected() {
        return this.redirected;
    }

    @JsonProperty(value="redirected")
    public void setRedirected(Boolean redirected) {
        this.redirected = redirected;
    }

    public LinkDetails withRedirected(Boolean redirected) {
        this.redirected = redirected;
        return this;
    }

    @JsonProperty(value="redirects")
    public List<String> getRedirects() {
        return this.redirects;
    }

    @JsonProperty(value="redirects")
    public void setRedirects(List<String> redirects) {
        this.redirects = redirects;
    }

    public LinkDetails withRedirects(List<String> redirects) {
        this.redirects = redirects;
        return this;
    }

    @JsonProperty(value="redirectCount")
    public Long getRedirectCount() {
        return this.redirectCount;
    }

    @JsonProperty(value="redirectCount")
    public void setRedirectCount(Long redirectCount) {
        this.redirectCount = redirectCount;
    }

    public LinkDetails withRedirectCount(Long redirectCount) {
        this.redirectCount = redirectCount;
        return this;
    }

    @JsonProperty(value="tracked")
    public Boolean getTracked() {
        return this.tracked;
    }

    @JsonProperty(value="tracked")
    public void setTracked(Boolean tracked) {
        this.tracked = tracked;
    }

    public LinkDetails withTracked(Boolean tracked) {
        this.tracked = tracked;
        return this;
    }

    @JsonProperty(value="finalResponseCode")
    public Long getFinalResponseCode() {
        return this.finalResponseCode;
    }

    @JsonProperty(value="finalResponseCode")
    public void setFinalResponseCode(Long finalResponseCode) {
        this.finalResponseCode = finalResponseCode;
    }

    public LinkDetails withFinalResponseCode(Long finalResponseCode) {
        this.finalResponseCode = finalResponseCode;
        return this;
    }

    @JsonProperty(value="cookies")
    public Set<String> getCookies() {
        return this.cookies;
    }

    @JsonProperty(value="cookies")
    public void setCookies(Set<String> cookies) {
        this.cookies = cookies;
    }

    public LinkDetails withCookies(Set<String> cookies) {
        this.cookies = cookies;
        return this;
    }

    @JsonProperty(value="startTime")
    public DateTime getStartTime() {
        return this.startTime;
    }

    @JsonProperty(value="startTime")
    public void setStartTime(DateTime startTime) {
        this.startTime = startTime;
    }

    public LinkDetails withStartTime(DateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @JsonProperty(value="tookInMills")
    public Long getTookInMills() {
        return this.tookInMills;
    }

    @JsonProperty(value="tookInMills")
    public void setTookInMills(Long tookInMills) {
        this.tookInMills = tookInMills;
    }

    public LinkDetails withTookInMills(Long tookInMills) {
        this.tookInMills = tookInMills;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public LinkDetails withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.linkStatus).append((Object)this.originalURL).append((Object)this.finalURL).append((Object)this.normalizedURL).append(this.urlParts).append((Object)this.domain).append((Object)this.redirected).append(this.redirects).append((Object)this.redirectCount).append((Object)this.tracked).append((Object)this.finalResponseCode).append(this.cookies).append((Object)this.startTime).append((Object)this.tookInMills).append(this.additionalProperties).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LinkDetails)) {
            return false;
        }
        LinkDetails rhs = (LinkDetails)other;
        return new EqualsBuilder().append((Object)this.linkStatus, (Object)rhs.linkStatus).append((Object)this.originalURL, (Object)rhs.originalURL).append((Object)this.finalURL, (Object)rhs.finalURL).append((Object)this.normalizedURL, (Object)rhs.normalizedURL).append(this.urlParts, rhs.urlParts).append((Object)this.domain, (Object)rhs.domain).append((Object)this.redirected, (Object)rhs.redirected).append(this.redirects, rhs.redirects).append((Object)this.redirectCount, (Object)rhs.redirectCount).append((Object)this.tracked, (Object)rhs.tracked).append((Object)this.finalResponseCode, (Object)rhs.finalResponseCode).append(this.cookies, rhs.cookies).append((Object)this.startTime, (Object)rhs.startTime).append((Object)this.tookInMills, (Object)rhs.tookInMills).append(this.additionalProperties, rhs.additionalProperties).isEquals();
    }

    public static enum LinkStatus {
        SUCCESS("SUCCESS"),
        ERROR("ERROR"),
        MALFORMED_URL("MALFORMED_URL"),
        NOT_FOUND("NOT_FOUND"),
        FORBIDDEN("FORBIDDEN"),
        REDIRECT_ERROR("REDIRECT_ERROR"),
        UNAUTHORIZED("UNAUTHORIZED"),
        LOOP("LOOP"),
        HTTP_ERROR_STATUS("HTTP_ERROR_STATUS"),
        EXCEPTION("EXCEPTION");

        private final String value;
        private static Map<String, LinkStatus> constants;

        private LinkStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static LinkStatus fromValue(String value) {
            LinkStatus constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, LinkStatus>();
            for (LinkStatus c : LinkStatus.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

