/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.regex;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.streams.regex.RegexUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RegexUtilsTest {
    private final String pattern;
    private final String content;
    private final int wordMatchCount;
    private final int regularMatchCount;

    public RegexUtilsTest(String pattern, String content, int regularMatchCount, int wordMatchCount) {
        this.pattern = pattern;
        this.content = content;
        this.wordMatchCount = wordMatchCount;
        this.regularMatchCount = regularMatchCount;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"[0-9]*", "The number for emergencies is 911.", 1, 1}, {"#\\w+", "This is#freakingcrazydude.", 1, 0}, {"#\\w+", "This is #freakingcrazydude.", 1, 1}, {"#\\w+", "This is #freakingcrazydude!", 1, 1}, {"#\\w+", "This is #freakingcrazydude I went to the moon", 1, 1}, {"#\\w+", "This is #freakingcrazydude I went to the #crazy? party", 2, 2}, {"#\\w+", "This is #freakingcrazydude I went to the #crazy; party", 2, 2}, {"#\\w+", "This is #freakingcrazydude I went to the #crazy, party", 2, 2}, {"#\\w+", "This is#freakingcrazydude I went to the #crazy party", 2, 1}, {"#\\w+", "This is #freakingcrazydude I went to the #freakingcrazydude party", 1, 1}, {"#\\w+", "#what does the fox say?", 1, 1}, {"#\\w+", "#what does the fox #say", 2, 2});
    }

    @Test
    public void testMatches_simple() {
        Map wordResults = RegexUtils.extractWordMatches((String)this.pattern, (String)this.content);
        Assert.assertThat((Object)wordResults.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.wordMatchCount)));
        Map regularResults = RegexUtils.extractMatches((String)this.pattern, (String)this.content);
        Assert.assertThat((Object)regularResults.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.regularMatchCount)));
    }
}

