/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.regex;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.pojo.json.Activity;
import org.apache.streams.regex.RegexUrlExtractor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RegexUrlExtractorTest {
    private Activity activity = new Activity();
    private Set<String> links;

    public RegexUrlExtractorTest(String activityContent, Set<String> links) {
        this.activity.setContent(activityContent);
        this.links = links;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        return Arrays.asList({"This is the http://t.co/foo of a standard tweet", Sets.newHashSet((Object[])new String[]{"http://t.co/foo"})}, {"This is the https://t.co/foo of a standard tweet", Sets.newHashSet((Object[])new String[]{"https://t.co/foo"})}, {"This is the https://t.co/foo of a standard tweet https://t.co/foo", Sets.newHashSet((Object[])new String[]{"https://t.co/foo"})}, {"This is the http://amd.com/test of a standard tweet", Sets.newHashSet((Object[])new String[]{"http://amd.com/test"})}, {"This is the content of a standard tweet", Sets.newHashSet()}, {"This is the http://www.google.com/articles/awesome?with=query&params=true of a standard @tweet", Sets.newHashSet((Object[])new String[]{"http://www.google.com/articles/awesome?with=query&params=true"})});
    }

    @Test
    public void testExtraction() {
        StreamsDatum datum = new StreamsDatum((Object)this.activity, "Test");
        List result = new RegexUrlExtractor().process(datum);
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1)));
        Activity output = (Activity)((StreamsDatum)result.get(0)).getDocument();
        HashSet extracted = Sets.newHashSet((Iterable)output.getLinks());
        Sets.SetView diff = Sets.difference(this.links, (Set)extracted);
        Assert.assertThat((Object)diff.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
    }
}

