/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.regex;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.pojo.extensions.ExtensionUtil;
import org.apache.streams.pojo.json.Activity;
import org.apache.streams.regex.RegexMentionsExtractor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RegexMentionExtractorTest {
    private Activity activity = new Activity();
    private Set<Map<String, Object>> mentions;

    public RegexMentionExtractorTest(String activityContent, Set<Map<String, Object>> hashtags) {
        this.activity.setContent(activityContent);
        this.mentions = hashtags;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        return Arrays.asList({"This is the @content of a standard tweet", Sets.newHashSet((Object[])new 1[]{new HashMap<String, Object>(){
            {
                this.put("displayName", "content");
            }
        }})}, {"This is the content of a standard tweet", Sets.newHashSet((Object[])new HashMap[]{new HashMap()})}, {"This is the @content of a standard @tweet", Sets.newHashSet((Object[])new HashMap[]{new HashMap<String, Object>(){
            {
                this.put("displayName", "content");
            }
        }, new HashMap<String, Object>(){
            {
                this.put("displayName", "tweet");
            }
        }})}, {"UNIX \u65f6\u95f41400000000 \u79d2\u2026\u2026 \uff08\u8be5\u7761\u89c9\u4e86\uff0c\u5404\u4f4d\u591c\u732b\u5b50\uff09@\u7a0b\u5e8f\u5458#", Sets.newHashSet((Object[])new 4[]{new HashMap<String, Object>(){
            {
                this.put("displayName", "\u7a0b\u5e8f\u5458");
            }
        }})}, {"This is the body of a @fbpost. It can have multiple lines of #content, as well as much more detailed and flowery @language.", Sets.newHashSet((Object[])new HashMap[]{new HashMap<String, Object>(){
            {
                this.put("displayName", "fbpost");
            }
        }, new HashMap<String, Object>(){
            {
                this.put("displayName", "language");
            }
        }})});
    }

    @Test
    public void testExtraction() {
        StreamsDatum datum = new StreamsDatum((Object)this.activity, "Test");
        List result = new RegexMentionsExtractor().process(datum);
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1)));
        Activity output = (Activity)((StreamsDatum)result.get(0)).getDocument();
        Set extracted = (Set)ExtensionUtil.getInstance().ensureExtensions(output).get("user_mentions");
        Sets.SetView diff = Sets.difference((Set)extracted, this.mentions);
        Assert.assertThat((Object)diff.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
    }
}

