/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.peoplepattern;

import java.util.HashMap;
import java.util.Map;
import org.apache.streams.components.http.HttpProcessorConfiguration;
import org.apache.streams.components.http.processor.SimpleHTTPGetProcessor;
import org.apache.streams.config.ComponentConfigurator;
import org.apache.streams.config.StreamsConfigurator;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.pojo.extensions.ExtensionUtil;
import org.apache.streams.pojo.json.Activity;
import org.apache.streams.pojo.json.ActivityObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DemographicsProcessor
extends SimpleHTTPGetProcessor {
    public static final String STREAMS_ID = "DemographicsProcessor";
    private static final Logger LOGGER = LoggerFactory.getLogger(DemographicsProcessor.class);

    public DemographicsProcessor() {
        this((HttpProcessorConfiguration)new ComponentConfigurator(HttpProcessorConfiguration.class).detectConfiguration(StreamsConfigurator.getConfig().getConfig("peoplepattern")));
    }

    public DemographicsProcessor(HttpProcessorConfiguration peoplePatternConfiguration) {
        super(peoplePatternConfiguration);
        LOGGER.info("creating DemographicsProcessor");
        this.configuration.setProtocol("https");
        this.configuration.setHostname("api.peoplepattern.com");
        this.configuration.setResourcePath("/v0.2/demographics/");
        this.configuration.setEntity(HttpProcessorConfiguration.Entity.ACTOR);
        this.configuration.setExtension("demographics");
    }

    protected Map<String, String> prepareParams(StreamsDatum entry) {
        Activity activity = (Activity)this.mapper.convertValue(entry.getDocument(), Activity.class);
        ActivityObject actor = (ActivityObject)this.mapper.convertValue((Object)activity.getActor(), ActivityObject.class);
        String username = (String)ExtensionUtil.getInstance().getExtension(actor, "screenName");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", actor.getId());
        params.put("name", actor.getDisplayName());
        params.put("username", username);
        params.put("description", actor.getSummary());
        return params;
    }
}

