/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.json.test;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.json.JsonPathExtractor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPathExtractorTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonPathExtractorTest.class);
    private String testJson;

    @Before
    public void initialize() {
        try {
            this.testJson = FileUtils.readFileToString((File)new File("src/test/resources/books.json"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void test1() {
        JsonPathExtractor extractor = new JsonPathExtractor();
        extractor.prepare((Object)"$.store.book[*].author");
        List result = extractor.process(new StreamsDatum((Object)this.testJson));
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertTrue((boolean)(((StreamsDatum)result.get(0)).getDocument() instanceof String));
        Assert.assertTrue((boolean)(((StreamsDatum)result.get(1)).getDocument() instanceof String));
    }

    @Test
    public void test2() {
        JsonPathExtractor extractor = new JsonPathExtractor();
        extractor.prepare((Object)"$.store.book[?(@.category == 'reference')]");
        List result = extractor.process(new StreamsDatum((Object)this.testJson));
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)(((StreamsDatum)result.get(0)).getDocument() instanceof ObjectNode));
    }

    @Test
    public void test3() {
        JsonPathExtractor extractor = new JsonPathExtractor();
        extractor.prepare((Object)"$.store.book[?(@.price > 10)]");
        List result = extractor.process(new StreamsDatum((Object)this.testJson));
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)(((StreamsDatum)result.get(0)).getDocument() instanceof ObjectNode));
    }

    @Test
    public void test4() {
        JsonPathExtractor extractor = new JsonPathExtractor();
        extractor.prepare((Object)"$.store.book[?(@.isbn)]");
        List result = extractor.process(new StreamsDatum((Object)this.testJson));
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertTrue((boolean)(((StreamsDatum)result.get(0)).getDocument() instanceof ObjectNode));
    }
}

