/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.s3;

import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import org.apache.streams.core.DatumStatus;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.s3.S3ObjectInputStreamWrapper;
import org.apache.streams.s3.S3PersistReader;
import org.apache.streams.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3PersistReaderTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3PersistReaderTask.class);
    private S3PersistReader reader;

    public S3PersistReaderTask(S3PersistReader reader) {
        this.reader = reader;
    }

    @Override
    public void run() {
        for (String file : this.reader.getFiles()) {
            S3ObjectInputStreamWrapper is = new S3ObjectInputStreamWrapper(this.reader.getAmazonS3Client().getObject(this.reader.getBucketName(), file));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
            LOGGER.info("Reading: {} ", (Object)file);
            try {
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    if (Strings.isNullOrEmpty((String)line)) continue;
                    this.reader.countersCurrent.incrementAttempt();
                    StreamsDatum entry = this.reader.lineReaderUtil.processLine(line);
                    ComponentUtils.offerUntilSuccess((Object)entry, this.reader.persistQueue);
                    this.reader.countersCurrent.incrementStatus(DatumStatus.SUCCESS);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                LOGGER.warn(ex.getMessage());
                this.reader.countersCurrent.incrementStatus(DatumStatus.FAIL);
            }
            LOGGER.info("Completed:  " + file);
            try {
                S3PersistReaderTask.closeSafely(file, is);
            }
            catch (Exception ex) {
                LOGGER.error(ex.getMessage());
            }
        }
    }

    private static void closeSafely(String file, Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception ex) {
            LOGGER.error("There was an issue closing file: {}", (Object)file);
        }
    }
}

