/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.Upload;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3OutputStreamWrapper
extends OutputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3OutputStreamWrapper.class);
    private final AmazonS3Client amazonS3Client;
    private final String bucketName;
    private final String path;
    private final String fileName;
    private ByteArrayOutputStream outputStream;
    private final Map<String, String> metaData;
    private boolean isClosed = false;

    public S3OutputStreamWrapper(AmazonS3Client amazonS3Client, String bucketName, String path, String fileName, Map<String, String> metaData) throws IOException {
        this.amazonS3Client = amazonS3Client;
        this.bucketName = bucketName;
        this.path = path;
        this.fileName = fileName;
        this.metaData = metaData;
        this.outputStream = new ByteArrayOutputStream();
    }

    @Override
    public void write(int byt) throws IOException {
        this.outputStream.write(byt);
    }

    @Override
    public void write(byte[] byt) throws IOException {
        this.outputStream.write(byt);
    }

    @Override
    public void write(byte[] byt, int off, int len) throws IOException {
        this.outputStream.write(byt, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            try {
                this.addFile();
                this.outputStream.close();
                this.outputStream = null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                LOGGER.warn("There was an error adding the temporaryFile to S3");
            }
            finally {
                this.isClosed = true;
            }
        }
    }

    private void addFile() throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(this.outputStream.toByteArray());
        int contentLength = this.outputStream.size();
        TransferManager transferManager = new TransferManager((AmazonS3)this.amazonS3Client);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setExpirationTime(DateTime.now().plusDays(1095).toDate());
        metadata.setContentLength((long)contentLength);
        metadata.addUserMetadata("writer", "org.apache.streams");
        for (String s : this.metaData.keySet()) {
            metadata.addUserMetadata(s, this.metaData.get(s));
        }
        String fileNameToWrite = this.path + this.fileName;
        Upload upload = transferManager.upload(this.bucketName, fileNameToWrite, (InputStream)is, metadata);
        try {
            upload.waitForUploadResult();
            ((InputStream)is).close();
            transferManager.shutdownNow(false);
            LOGGER.info("S3 File Close[{} kb] - {}", (Object)(contentLength / 1024), (Object)(this.path + this.fileName));
        }
        catch (Exception ignored) {
            LOGGER.trace("Ignoring", (Throwable)ignored);
        }
    }
}

