/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.s3;

import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ObjectInputStreamWrapper
extends InputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3ObjectInputStreamWrapper.class);
    private final S3Object s3Object;
    private final S3ObjectInputStream is;
    private boolean isClosed = false;

    public S3ObjectInputStreamWrapper(S3Object s3Object) {
        this.s3Object = s3Object;
        this.is = this.s3Object.getObjectContent();
    }

    public int hashCode() {
        return this.is.hashCode();
    }

    public boolean equals(Object obj) {
        return this.is.equals(obj);
    }

    public String toString() {
        return this.is.toString();
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }

    @Override
    public int read(byte[] byt) throws IOException {
        return this.is.read(byt);
    }

    @Override
    public int read(byte[] byt, int off, int len) throws IOException {
        return this.is.read(byt, off, len);
    }

    @Override
    public long skip(long skip) throws IOException {
        return this.is.skip(skip);
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.is.reset();
    }

    @Override
    public void close() throws IOException {
        this.ensureEverythingIsReleased();
    }

    public void ensureEverythingIsReleased() {
        if (this.isClosed) {
            return;
        }
        try {
            this.s3Object.close();
        }
        catch (Throwable ex) {
            LOGGER.warn("Problem Closing the S3Object[{}]: {}", (Object)this.s3Object.getKey(), (Object)ex.getMessage());
        }
        try {
            this.is.abort();
        }
        catch (Throwable ex) {
            LOGGER.warn("Problem Aborting S3Object[{}]: {}", (Object)this.s3Object.getKey(), (Object)ex.getMessage());
        }
        S3ObjectInputStreamWrapper.closeSafely((Closeable)this.is);
        S3ObjectInputStreamWrapper.closeSafely((Closeable)this.s3Object);
        this.isClosed = true;
    }

    private static void closeSafely(Closeable is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LOGGER.warn("S3InputStreamWrapper: Issue Closing Closeable - {}", (Object)ex.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.ensureEverythingIsReleased();
            super.finalize();
        }
        catch (Exception ex) {
            LOGGER.warn("S3InputStreamWrapper: Issue Releasing Connections on Finalize - {}", (Object)ex.getMessage());
        }
    }
}

