/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.s3;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.streams.converter.LineReadWriteConfiguration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"key", "secretKey", "bucket", "protocol", "region"})
public class S3Configuration
extends LineReadWriteConfiguration
implements Serializable {
    @JsonProperty(value="key")
    @NotNull
    private String key;
    @JsonProperty(value="secretKey")
    @NotNull
    private String secretKey;
    @JsonProperty(value="bucket")
    @NotNull
    private String bucket;
    @JsonProperty(value="protocol")
    private Protocol protocol = Protocol.fromValue("HTTPS");
    @JsonProperty(value="region")
    private String region;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    public S3Configuration withKey(String key) {
        this.key = key;
        return this;
    }

    @JsonProperty(value="secretKey")
    public String getSecretKey() {
        return this.secretKey;
    }

    @JsonProperty(value="secretKey")
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public S3Configuration withSecretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    @JsonProperty(value="bucket")
    public String getBucket() {
        return this.bucket;
    }

    @JsonProperty(value="bucket")
    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public S3Configuration withBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    @JsonProperty(value="protocol")
    public Protocol getProtocol() {
        return this.protocol;
    }

    @JsonProperty(value="protocol")
    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public S3Configuration withProtocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    @JsonProperty(value="region")
    public String getRegion() {
        return this.region;
    }

    @JsonProperty(value="region")
    public void setRegion(String region) {
        this.region = region;
    }

    public S3Configuration withRegion(String region) {
        this.region = region;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public S3Configuration withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.key).append((Object)this.secretKey).append((Object)this.bucket).append((Object)this.protocol).append((Object)this.region).append(this.additionalProperties).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof S3Configuration)) {
            return false;
        }
        S3Configuration rhs = (S3Configuration)other;
        return new EqualsBuilder().append((Object)this.key, (Object)rhs.key).append((Object)this.secretKey, (Object)rhs.secretKey).append((Object)this.bucket, (Object)rhs.bucket).append((Object)this.protocol, (Object)rhs.protocol).append((Object)this.region, (Object)rhs.region).append(this.additionalProperties, rhs.additionalProperties).isEquals();
    }

    public static enum Protocol {
        HTTP("HTTP"),
        HTTPS("HTTPS");

        private final String value;
        private static Map<String, Protocol> constants;

        private Protocol(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Protocol fromValue(String value) {
            Protocol constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, Protocol>();
            for (Protocol c : Protocol.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

