/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.neo4j.test;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigParseOptions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.streams.config.ComponentConfigurator;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.core.StreamsResultSet;
import org.apache.streams.jackson.StreamsJacksonMapper;
import org.apache.streams.neo4j.Neo4jConfiguration;
import org.apache.streams.neo4j.Neo4jReaderConfiguration;
import org.apache.streams.neo4j.http.Neo4jHttpClient;
import org.apache.streams.neo4j.http.Neo4jHttpPersistReader;
import org.apache.streams.neo4j.http.Neo4jHttpPersistWriter;
import org.apache.streams.pojo.json.Activity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class Neo4jHttpPersistIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(Neo4jHttpPersistIT.class);
    private static final ObjectMapper MAPPER = StreamsJacksonMapper.getInstance();
    private Neo4jHttpClient testClient;
    private Neo4jConfiguration testConfiguration;

    @BeforeClass
    public void prepareTest() throws IOException {
        Config reference = ConfigFactory.load();
        File conf = new File("target/test-classes/Neo4jHttpPersistIT.conf");
        Assert.assertTrue((boolean)conf.exists());
        Config testResourceConfig = ConfigFactory.parseFileAnySyntax((File)conf, (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false));
        Config typesafe = testResourceConfig.withFallback((ConfigMergeable)reference).resolve();
        this.testConfiguration = (Neo4jConfiguration)new ComponentConfigurator(Neo4jConfiguration.class).detectConfiguration(typesafe, "neo4j");
    }

    @Test
    public void testNeo4jHttpPersist() throws Exception {
        Neo4jHttpPersistWriter testPersistWriter = new Neo4jHttpPersistWriter(this.testConfiguration);
        testPersistWriter.prepare(null);
        InputStream testActivityFolderStream = Neo4jHttpPersistIT.class.getClassLoader().getResourceAsStream("activities");
        List files = IOUtils.readLines((InputStream)testActivityFolderStream, (Charset)StandardCharsets.UTF_8);
        int count = 0;
        for (String file : files) {
            LOGGER.info("File: " + file);
            InputStream testActivityFileStream = Neo4jHttpPersistIT.class.getClassLoader().getResourceAsStream("activities/" + file);
            Activity activity = (Activity)MAPPER.readValue(testActivityFileStream, Activity.class);
            if (activity.getActor() != null && activity.getActor().getId() == null && activity.getActor().getObjectType() != null) {
                activity.getActor().setId(activity.getActor().getObjectType());
            }
            if (activity.getObject() != null && activity.getObject().getId() == null && activity.getObject().getObjectType() != null) {
                activity.getObject().setId(activity.getObject().getObjectType());
            }
            if (activity.getTarget() != null && activity.getTarget().getId() == null && activity.getTarget().getObjectType() != null) {
                activity.getTarget().setId(activity.getTarget().getObjectType());
            }
            if (activity.getId() == null && activity.getVerb() != null) {
                activity.setId(activity.getVerb());
            }
            StreamsDatum datum = new StreamsDatum((Object)activity, activity.getVerb());
            testPersistWriter.write(datum);
            LOGGER.info("Wrote: " + activity.getVerb());
            ++count;
        }
        testPersistWriter.cleanUp();
        LOGGER.info("Total Written: {}", (Object)count);
        Assert.assertEquals((int)count, (int)89);
        Neo4jReaderConfiguration vertexReaderConfiguration = (Neo4jReaderConfiguration)MAPPER.convertValue((Object)this.testConfiguration, Neo4jReaderConfiguration.class);
        vertexReaderConfiguration.setQuery("MATCH (v) return v");
        Neo4jHttpPersistReader vertexReader = new Neo4jHttpPersistReader(vertexReaderConfiguration);
        vertexReader.prepare(null);
        StreamsResultSet vertexResultSet = vertexReader.readAll();
        LOGGER.info("Total Read: {}", (Object)vertexResultSet.size());
        Assert.assertEquals((int)vertexResultSet.size(), (int)24);
        Neo4jReaderConfiguration edgeReaderConfiguration = (Neo4jReaderConfiguration)MAPPER.convertValue((Object)this.testConfiguration, Neo4jReaderConfiguration.class);
        edgeReaderConfiguration.setQuery("MATCH (s)-[r]->(d) return r");
        Neo4jHttpPersistReader edgeReader = new Neo4jHttpPersistReader(edgeReaderConfiguration);
        edgeReader.prepare(null);
        StreamsResultSet edgeResultSet = edgeReader.readAll();
        LOGGER.info("Total Read: {}", (Object)edgeResultSet.size());
        Assert.assertEquals((int)edgeResultSet.size(), (int)100);
    }
}

