/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.kafka;

import java.util.Random;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.kafka.KafkaPersistWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPersistWriterTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaPersistWriterTask.class);
    private KafkaPersistWriter writer;

    public KafkaPersistWriterTask(KafkaPersistWriter writer) {
        this.writer = writer;
    }

    @Override
    public void run() {
        while (true) {
            if (this.writer.getPersistQueue().peek() != null) {
                try {
                    StreamsDatum entry = this.writer.persistQueue.remove();
                    this.writer.write(entry);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            try {
                Thread.sleep(new Random().nextInt(100));
                continue;
            }
            catch (InterruptedException interrupt) {
                LOGGER.trace("Interrupt", (Throwable)interrupt);
                continue;
            }
            break;
        }
    }
}

