/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.kafka;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerConfig;
import org.apache.streams.config.ComponentConfigurator;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.core.StreamsPersistWriter;
import org.apache.streams.kafka.KafkaConfiguration;
import org.apache.streams.kafka.KafkaPersistWriterTask;
import org.apache.streams.util.GuidUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPersistWriter
implements StreamsPersistWriter,
Serializable,
Runnable {
    public static final String STREAMS_ID = "KafkaPersistWriter";
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaPersistWriter.class);
    protected volatile Queue<StreamsDatum> persistQueue;
    private ObjectMapper mapper = new ObjectMapper();
    private KafkaConfiguration config = (KafkaConfiguration)new ComponentConfigurator(KafkaConfiguration.class).detectConfiguration();
    private Producer<String, String> producer;

    public KafkaPersistWriter() {
        this.persistQueue = new ConcurrentLinkedQueue<StreamsDatum>();
    }

    public KafkaPersistWriter(Queue<StreamsDatum> persistQueue) {
        this.persistQueue = persistQueue;
    }

    public void setConfig(KafkaConfiguration config) {
        this.config = config;
    }

    public void start() {
        Properties props = new Properties();
        props.put("metadata.broker.list", this.config.getBrokerlist());
        props.put("serializer.class", "kafka.serializer.StringEncoder");
        props.put("partitioner.class", "org.apache.streams.kafka.StreamsPartitioner");
        props.put("request.required.acks", "1");
        ProducerConfig config = new ProducerConfig(props);
        this.producer = new Producer(config);
        new Thread(new KafkaPersistWriterTask(this)).start();
    }

    public void stop() {
        this.producer.close();
    }

    public void setPersistQueue(Queue<StreamsDatum> persistQueue) {
        this.persistQueue = persistQueue;
    }

    public Queue<StreamsDatum> getPersistQueue() {
        return this.persistQueue;
    }

    public String getId() {
        return STREAMS_ID;
    }

    public void write(StreamsDatum entry) {
        try {
            String text = this.mapper.writeValueAsString((Object)entry);
            String hash = GuidUtils.generateGuid((String[])new String[]{text});
            KeyedMessage data = new KeyedMessage(this.config.getTopic(), (Object)hash, (Object)text);
            this.producer.send(data);
        }
        catch (JsonProcessingException ex) {
            LOGGER.warn("save: {}", (Throwable)ex);
        }
    }

    @Override
    public void run() {
        this.start();
    }

    public void prepare(Object configurationObject) {
        this.start();
    }

    public void cleanUp() {
        this.stop();
    }
}

