/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.kafka;

import java.util.Random;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.KafkaStream;
import kafka.message.MessageAndMetadata;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.kafka.KafkaPersistReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPersistReaderTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaPersistReaderTask.class);
    private KafkaPersistReader reader;
    private KafkaStream<String, String> stream;

    public KafkaPersistReaderTask(KafkaPersistReader reader, KafkaStream<String, String> stream) {
        this.reader = reader;
        this.stream = stream;
    }

    @Override
    public void run() {
        while (true) {
            ConsumerIterator consumerIterator = this.stream.iterator();
            while (consumerIterator.hasNext()) {
                MessageAndMetadata aStream;
                MessageAndMetadata item = aStream = (MessageAndMetadata)consumerIterator.next();
                this.reader.persistQueue.add(new StreamsDatum(item.message()));
            }
            try {
                Thread.sleep(new Random().nextInt(100));
                continue;
            }
            catch (InterruptedException interrupt) {
                LOGGER.trace("Interrupt", (Throwable)interrupt);
                continue;
            }
            break;
        }
    }
}

