/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.kafka;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kafka.consumer.Consumer;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.KafkaStream;
import kafka.consumer.TopicFilter;
import kafka.consumer.Whitelist;
import kafka.javaapi.consumer.ConsumerConnector;
import kafka.serializer.Decoder;
import kafka.serializer.StringDecoder;
import kafka.utils.VerifiableProperties;
import org.apache.streams.config.ComponentConfigurator;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.core.StreamsPersistReader;
import org.apache.streams.core.StreamsResultSet;
import org.apache.streams.kafka.KafkaConfiguration;
import org.apache.streams.kafka.KafkaPersistReaderTask;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPersistReader
implements StreamsPersistReader,
Serializable {
    public static final String STREAMS_ID = "KafkaPersistReader";
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaPersistReader.class);
    protected volatile Queue<StreamsDatum> persistQueue;
    private ObjectMapper mapper = new ObjectMapper();
    private KafkaConfiguration config;
    private ConsumerConnector consumerConnector;
    public List<KafkaStream<String, String>> inStreams;
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public KafkaPersistReader() {
        this.config = (KafkaConfiguration)new ComponentConfigurator(KafkaConfiguration.class).detectConfiguration();
        this.persistQueue = new ConcurrentLinkedQueue<StreamsDatum>();
    }

    public KafkaPersistReader(Queue<StreamsDatum> persistQueue) {
        this.config = (KafkaConfiguration)new ComponentConfigurator(KafkaConfiguration.class).detectConfiguration();
        this.persistQueue = persistQueue;
    }

    public void setConfig(KafkaConfiguration config) {
        this.config = config;
    }

    public String getId() {
        return STREAMS_ID;
    }

    public void startStream() {
        Properties props = new Properties();
        props.setProperty("serializer.encoding", "UTF8");
        ConsumerConfig consumerConfig = new ConsumerConfig(props);
        this.consumerConnector = Consumer.createJavaConsumerConnector((ConsumerConfig)consumerConfig);
        Whitelist topics = new Whitelist(this.config.getTopic());
        VerifiableProperties vprops = new VerifiableProperties(props);
        this.inStreams = this.consumerConnector.createMessageStreamsByFilter((TopicFilter)topics, 1, (Decoder)new StringDecoder(vprops), (Decoder)new StringDecoder(vprops));
        for (KafkaStream<String, String> stream : this.inStreams) {
            this.executor.submit(new KafkaPersistReaderTask(this, stream));
        }
    }

    public StreamsResultSet readAll() {
        return this.readCurrent();
    }

    public StreamsResultSet readCurrent() {
        return null;
    }

    public StreamsResultSet readNew(BigInteger bigInteger) {
        return null;
    }

    public StreamsResultSet readRange(DateTime dateTime, DateTime dateTime2) {
        return null;
    }

    public boolean isRunning() {
        return !this.executor.isShutdown() && !this.executor.isTerminated();
    }

    private static ConsumerConfig createConsumerConfig(String zookeeper, String groupId) {
        Properties props = new Properties();
        props.put("zookeeper.connect", zookeeper);
        props.put("group.id", groupId);
        props.put("zookeeper.session.timeout.ms", "400");
        props.put("zookeeper.sync.time.ms", "200");
        props.put("auto.commit.interval.ms", "1000");
        return new ConsumerConfig(props);
    }

    public void prepare(Object configurationObject) {
    }

    public void cleanUp() {
        this.consumerConnector.shutdown();
        while (!this.executor.isTerminated()) {
            try {
                this.executor.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interrupt) {
                LOGGER.trace("Interrupt", (Throwable)interrupt);
            }
        }
    }
}

