/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.hdfs;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.juneau.annotation.BeanProperty;
import org.apache.streams.hdfs.HdfsConfiguration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"writerPath", "writerFilePrefix", "linesPerFile", "compression"})
public class HdfsWriterConfiguration
extends HdfsConfiguration
implements Serializable {
    @JsonProperty(value="writerPath")
    @JsonPropertyDescription(value="Path ")
    @BeanProperty(value="writerPath")
    private String writerPath;
    @JsonProperty(value="writerFilePrefix")
    @JsonPropertyDescription(value="File Prefix")
    @BeanProperty(value="writerFilePrefix")
    private String writerFilePrefix;
    @JsonProperty(value="linesPerFile")
    @JsonPropertyDescription(value="Lines Per File")
    @BeanProperty(value="linesPerFile")
    private Long linesPerFile = 1000L;
    @JsonProperty(value="compression")
    @JsonPropertyDescription(value="compression")
    @BeanProperty(value="compression")
    private Compression compression = Compression.fromValue("none");
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    private static final long serialVersionUID = -6760055157049911660L;

    @JsonProperty(value="writerPath")
    public String getWriterPath() {
        return this.writerPath;
    }

    @JsonProperty(value="writerPath")
    public void setWriterPath(String writerPath) {
        this.writerPath = writerPath;
    }

    public HdfsWriterConfiguration withWriterPath(String writerPath) {
        this.writerPath = writerPath;
        return this;
    }

    @JsonProperty(value="writerFilePrefix")
    public String getWriterFilePrefix() {
        return this.writerFilePrefix;
    }

    @JsonProperty(value="writerFilePrefix")
    public void setWriterFilePrefix(String writerFilePrefix) {
        this.writerFilePrefix = writerFilePrefix;
    }

    public HdfsWriterConfiguration withWriterFilePrefix(String writerFilePrefix) {
        this.writerFilePrefix = writerFilePrefix;
        return this;
    }

    @JsonProperty(value="linesPerFile")
    public Long getLinesPerFile() {
        return this.linesPerFile;
    }

    @JsonProperty(value="linesPerFile")
    public void setLinesPerFile(Long linesPerFile) {
        this.linesPerFile = linesPerFile;
    }

    public HdfsWriterConfiguration withLinesPerFile(Long linesPerFile) {
        this.linesPerFile = linesPerFile;
        return this;
    }

    @JsonProperty(value="compression")
    public Compression getCompression() {
        return this.compression;
    }

    @JsonProperty(value="compression")
    public void setCompression(Compression compression) {
        this.compression = compression;
    }

    public HdfsWriterConfiguration withCompression(Compression compression) {
        this.compression = compression;
        return this;
    }

    @Override
    public HdfsWriterConfiguration withScheme(HdfsConfiguration.Scheme scheme) {
        super.withScheme(scheme);
        return this;
    }

    @Override
    public HdfsWriterConfiguration withHost(String host) {
        super.withHost(host);
        return this;
    }

    @Override
    public HdfsWriterConfiguration withPort(Long port) {
        super.withPort(port);
        return this;
    }

    @Override
    public HdfsWriterConfiguration withPath(String path) {
        super.withPath(path);
        return this;
    }

    @Override
    public HdfsWriterConfiguration withUser(String user) {
        super.withUser(user);
        return this;
    }

    @Override
    public HdfsWriterConfiguration withPassword(String password) {
        super.withPassword(password);
        return this;
    }

    @Override
    public HdfsWriterConfiguration withFields(List<String> fields) {
        super.withFields((List)fields);
        return this;
    }

    @Override
    public HdfsWriterConfiguration withFieldDelimiter(String fieldDelimiter) {
        super.withFieldDelimiter(fieldDelimiter);
        return this;
    }

    @Override
    public HdfsWriterConfiguration withLineDelimiter(String lineDelimiter) {
        super.withLineDelimiter(lineDelimiter);
        return this;
    }

    @Override
    public HdfsWriterConfiguration withEncoding(String encoding) {
        super.withEncoding(encoding);
        return this;
    }

    @Override
    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public HdfsWriterConfiguration withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(HdfsWriterConfiguration.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        int baseLength = sb.length();
        String superString = super.toString();
        if (superString != null) {
            int contentStart = superString.indexOf(91);
            int contentEnd = superString.lastIndexOf(93);
            if (contentStart >= 0 && contentEnd > contentStart) {
                sb.append(superString, contentStart + 1, contentEnd);
            } else {
                sb.append(superString);
            }
        }
        if (sb.length() > baseLength) {
            sb.append(',');
        }
        sb.append("writerPath");
        sb.append('=');
        sb.append(this.writerPath == null ? "<null>" : this.writerPath);
        sb.append(',');
        sb.append("writerFilePrefix");
        sb.append('=');
        sb.append(this.writerFilePrefix == null ? "<null>" : this.writerFilePrefix);
        sb.append(',');
        sb.append("linesPerFile");
        sb.append('=');
        sb.append(this.linesPerFile == null ? "<null>" : this.linesPerFile);
        sb.append(',');
        sb.append("compression");
        sb.append('=');
        sb.append(this.compression == null ? "<null>" : this.compression);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.writerPath == null ? 0 : this.writerPath.hashCode());
        result = result * 31 + (this.linesPerFile == null ? 0 : this.linesPerFile.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.compression == null ? 0 : this.compression.hashCode());
        result = result * 31 + (this.writerFilePrefix == null ? 0 : this.writerFilePrefix.hashCode());
        result = result * 31 + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof HdfsWriterConfiguration)) {
            return false;
        }
        HdfsWriterConfiguration rhs = (HdfsWriterConfiguration)other;
        return super.equals(rhs) && (this.writerPath == rhs.writerPath || this.writerPath != null && this.writerPath.equals(rhs.writerPath)) && (this.linesPerFile == rhs.linesPerFile || this.linesPerFile != null && this.linesPerFile.equals(rhs.linesPerFile)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.compression == rhs.compression || this.compression != null && this.compression.equals((Object)rhs.compression)) && (this.writerFilePrefix == rhs.writerFilePrefix || this.writerFilePrefix != null && this.writerFilePrefix.equals(rhs.writerFilePrefix));
    }

    public static enum Compression {
        NONE("none"),
        GZIP("gzip");

        private final String value;
        private static final Map<String, Compression> CONSTANTS;

        private Compression(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Compression fromValue(String value) {
            Compression constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Compression>();
            for (Compression c : Compression.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

