/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.hdfs;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.juneau.annotation.BeanProperty;
import org.apache.streams.hdfs.HdfsConfiguration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"readerPath"})
public class HdfsReaderConfiguration
extends HdfsConfiguration
implements Serializable {
    @JsonProperty(value="readerPath")
    @JsonPropertyDescription(value="Path below root path")
    @BeanProperty(value="readerPath")
    private String readerPath;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    private static final long serialVersionUID = 3491184877384088224L;

    @JsonProperty(value="readerPath")
    public String getReaderPath() {
        return this.readerPath;
    }

    @JsonProperty(value="readerPath")
    public void setReaderPath(String readerPath) {
        this.readerPath = readerPath;
    }

    public HdfsReaderConfiguration withReaderPath(String readerPath) {
        this.readerPath = readerPath;
        return this;
    }

    @Override
    public HdfsReaderConfiguration withScheme(HdfsConfiguration.Scheme scheme) {
        super.withScheme(scheme);
        return this;
    }

    @Override
    public HdfsReaderConfiguration withHost(String host) {
        super.withHost(host);
        return this;
    }

    @Override
    public HdfsReaderConfiguration withPort(Long port) {
        super.withPort(port);
        return this;
    }

    @Override
    public HdfsReaderConfiguration withPath(String path) {
        super.withPath(path);
        return this;
    }

    @Override
    public HdfsReaderConfiguration withUser(String user) {
        super.withUser(user);
        return this;
    }

    @Override
    public HdfsReaderConfiguration withPassword(String password) {
        super.withPassword(password);
        return this;
    }

    @Override
    public HdfsReaderConfiguration withFields(List<String> fields) {
        super.withFields((List)fields);
        return this;
    }

    @Override
    public HdfsReaderConfiguration withFieldDelimiter(String fieldDelimiter) {
        super.withFieldDelimiter(fieldDelimiter);
        return this;
    }

    @Override
    public HdfsReaderConfiguration withLineDelimiter(String lineDelimiter) {
        super.withLineDelimiter(lineDelimiter);
        return this;
    }

    @Override
    public HdfsReaderConfiguration withEncoding(String encoding) {
        super.withEncoding(encoding);
        return this;
    }

    @Override
    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public HdfsReaderConfiguration withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(HdfsReaderConfiguration.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        int baseLength = sb.length();
        String superString = super.toString();
        if (superString != null) {
            int contentStart = superString.indexOf(91);
            int contentEnd = superString.lastIndexOf(93);
            if (contentStart >= 0 && contentEnd > contentStart) {
                sb.append(superString, contentStart + 1, contentEnd);
            } else {
                sb.append(superString);
            }
        }
        if (sb.length() > baseLength) {
            sb.append(',');
        }
        sb.append("readerPath");
        sb.append('=');
        sb.append(this.readerPath == null ? "<null>" : this.readerPath);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.readerPath == null ? 0 : this.readerPath.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof HdfsReaderConfiguration)) {
            return false;
        }
        HdfsReaderConfiguration rhs = (HdfsReaderConfiguration)other;
        return super.equals(rhs) && (this.readerPath == rhs.readerPath || this.readerPath != null && this.readerPath.equals(rhs.readerPath)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties));
    }
}

