/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.hdfs;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.juneau.annotation.BeanProperty;
import org.apache.streams.converter.LineReadWriteConfiguration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"scheme", "host", "port", "path", "user", "password"})
public class HdfsConfiguration
extends LineReadWriteConfiguration
implements Serializable {
    @JsonProperty(value="scheme")
    @JsonPropertyDescription(value="scheme")
    @BeanProperty(value="scheme")
    private Scheme scheme = Scheme.fromValue("webhdfs");
    @JsonProperty(value="host")
    @JsonPropertyDescription(value="WebHdfs host")
    @BeanProperty(value="host")
    private String host;
    @JsonProperty(value="port")
    @JsonPropertyDescription(value="WebHdfs port")
    @BeanProperty(value="port")
    private Long port;
    @JsonProperty(value="path")
    @JsonPropertyDescription(value="Base path")
    @BeanProperty(value="path")
    private String path;
    @JsonProperty(value="user")
    @JsonPropertyDescription(value="User")
    @BeanProperty(value="user")
    private String user;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="Password")
    @BeanProperty(value="password")
    private String password;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    private static final long serialVersionUID = -7988404696667073687L;

    @JsonProperty(value="scheme")
    public Scheme getScheme() {
        return this.scheme;
    }

    @JsonProperty(value="scheme")
    public void setScheme(Scheme scheme) {
        this.scheme = scheme;
    }

    public HdfsConfiguration withScheme(Scheme scheme) {
        this.scheme = scheme;
        return this;
    }

    @JsonProperty(value="host")
    public String getHost() {
        return this.host;
    }

    @JsonProperty(value="host")
    public void setHost(String host) {
        this.host = host;
    }

    public HdfsConfiguration withHost(String host) {
        this.host = host;
        return this;
    }

    @JsonProperty(value="port")
    public Long getPort() {
        return this.port;
    }

    @JsonProperty(value="port")
    public void setPort(Long port) {
        this.port = port;
    }

    public HdfsConfiguration withPort(Long port) {
        this.port = port;
        return this;
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    public void setPath(String path) {
        this.path = path;
    }

    public HdfsConfiguration withPath(String path) {
        this.path = path;
        return this;
    }

    @JsonProperty(value="user")
    public String getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    public void setUser(String user) {
        this.user = user;
    }

    public HdfsConfiguration withUser(String user) {
        this.user = user;
        return this;
    }

    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    public void setPassword(String password) {
        this.password = password;
    }

    public HdfsConfiguration withPassword(String password) {
        this.password = password;
        return this;
    }

    @Override
    public HdfsConfiguration withFields(List<String> fields) {
        super.withFields(fields);
        return this;
    }

    @Override
    public HdfsConfiguration withFieldDelimiter(String fieldDelimiter) {
        super.withFieldDelimiter(fieldDelimiter);
        return this;
    }

    @Override
    public HdfsConfiguration withLineDelimiter(String lineDelimiter) {
        super.withLineDelimiter(lineDelimiter);
        return this;
    }

    @Override
    public HdfsConfiguration withEncoding(String encoding) {
        super.withEncoding(encoding);
        return this;
    }

    @Override
    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public HdfsConfiguration withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(HdfsConfiguration.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        int baseLength = sb.length();
        String superString = super.toString();
        if (superString != null) {
            int contentStart = superString.indexOf(91);
            int contentEnd = superString.lastIndexOf(93);
            if (contentStart >= 0 && contentEnd > contentStart) {
                sb.append(superString, contentStart + 1, contentEnd);
            } else {
                sb.append(superString);
            }
        }
        if (sb.length() > baseLength) {
            sb.append(',');
        }
        sb.append("scheme");
        sb.append('=');
        sb.append(this.scheme == null ? "<null>" : this.scheme);
        sb.append(',');
        sb.append("host");
        sb.append('=');
        sb.append(this.host == null ? "<null>" : this.host);
        sb.append(',');
        sb.append("port");
        sb.append('=');
        sb.append(this.port == null ? "<null>" : this.port);
        sb.append(',');
        sb.append("path");
        sb.append('=');
        sb.append(this.path == null ? "<null>" : this.path);
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(this.user == null ? "<null>" : this.user);
        sb.append(',');
        sb.append("password");
        sb.append('=');
        sb.append(this.password == null ? "<null>" : this.password);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.path == null ? 0 : this.path.hashCode());
        result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 31 + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = result * 31 + (this.port == null ? 0 : this.port.hashCode());
        result = result * 31 + (this.host == null ? 0 : this.host.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.user == null ? 0 : this.user.hashCode());
        result = result * 31 + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof HdfsConfiguration)) {
            return false;
        }
        HdfsConfiguration rhs = (HdfsConfiguration)other;
        return super.equals(rhs) && (this.path == rhs.path || this.path != null && this.path.equals(rhs.path)) && (this.password == rhs.password || this.password != null && this.password.equals(rhs.password)) && (this.scheme == rhs.scheme || this.scheme != null && this.scheme.equals((Object)rhs.scheme)) && (this.port == rhs.port || this.port != null && this.port.equals(rhs.port)) && (this.host == rhs.host || this.host != null && this.host.equals(rhs.host)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.user == rhs.user || this.user != null && this.user.equals(rhs.user));
    }

    public static enum Scheme {
        FILE("file"),
        HDFS("hdfs"),
        WEBHDFS("webhdfs"),
        S_3("s3"),
        S_3_N("s3n"),
        S_3_A("s3a"),
        EMRFS("emrfs");

        private final String value;
        private static final Map<String, Scheme> CONSTANTS;

        private Scheme(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Scheme fromValue(String value) {
            Scheme constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Scheme>();
            for (Scheme c : Scheme.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

