/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.hdfs;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.juneau.annotation.BeanProperty;
import org.apache.streams.converter.LineReadWriteConfiguration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"scheme", "host", "port", "path", "user", "password"})
public class HdfsConfiguration
extends LineReadWriteConfiguration
implements Serializable {
    @JsonProperty(value="scheme")
    @BeanProperty(value="scheme")
    private Scheme scheme = Scheme.fromValue("webhdfs");
    @JsonProperty(value="host")
    @BeanProperty(value="host")
    private String host;
    @JsonProperty(value="port")
    @BeanProperty(value="port")
    private Long port;
    @JsonProperty(value="path")
    @BeanProperty(value="path")
    private String path;
    @JsonProperty(value="user")
    @BeanProperty(value="user")
    private String user;
    @JsonProperty(value="password")
    @BeanProperty(value="password")
    private String password;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="scheme")
    @BeanProperty(value="scheme")
    public Scheme getScheme() {
        return this.scheme;
    }

    @JsonProperty(value="scheme")
    @BeanProperty(value="scheme")
    public void setScheme(Scheme scheme) {
        this.scheme = scheme;
    }

    public HdfsConfiguration withScheme(Scheme scheme) {
        this.scheme = scheme;
        return this;
    }

    @JsonProperty(value="host")
    @BeanProperty(value="host")
    public String getHost() {
        return this.host;
    }

    @JsonProperty(value="host")
    @BeanProperty(value="host")
    public void setHost(String host) {
        this.host = host;
    }

    public HdfsConfiguration withHost(String host) {
        this.host = host;
        return this;
    }

    @JsonProperty(value="port")
    @BeanProperty(value="port")
    public Long getPort() {
        return this.port;
    }

    @JsonProperty(value="port")
    @BeanProperty(value="port")
    public void setPort(Long port) {
        this.port = port;
    }

    public HdfsConfiguration withPort(Long port) {
        this.port = port;
        return this;
    }

    @JsonProperty(value="path")
    @BeanProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    @BeanProperty(value="path")
    public void setPath(String path) {
        this.path = path;
    }

    public HdfsConfiguration withPath(String path) {
        this.path = path;
        return this;
    }

    @JsonProperty(value="user")
    @BeanProperty(value="user")
    public String getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @BeanProperty(value="user")
    public void setUser(String user) {
        this.user = user;
    }

    public HdfsConfiguration withUser(String user) {
        this.user = user;
        return this;
    }

    @JsonProperty(value="password")
    @BeanProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @BeanProperty(value="password")
    public void setPassword(String password) {
        this.password = password;
    }

    public HdfsConfiguration withPassword(String password) {
        this.password = password;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @JsonAnyGetter
    @BeanProperty(name="*")
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    @BeanProperty(name="*")
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public HdfsConfiguration withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.scheme).append((Object)this.host).append((Object)this.port).append((Object)this.path).append((Object)this.user).append((Object)this.password).append(this.additionalProperties).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof HdfsConfiguration)) {
            return false;
        }
        HdfsConfiguration rhs = (HdfsConfiguration)other;
        return new EqualsBuilder().append((Object)this.scheme, (Object)rhs.scheme).append((Object)this.host, (Object)rhs.host).append((Object)this.port, (Object)rhs.port).append((Object)this.path, (Object)rhs.path).append((Object)this.user, (Object)rhs.user).append((Object)this.password, (Object)rhs.password).append(this.additionalProperties, rhs.additionalProperties).isEquals();
    }

    public static enum Scheme {
        FILE("file"),
        HDFS("hdfs"),
        WEBHDFS("webhdfs"),
        S_3("s3"),
        S_3_N("s3n"),
        S_3_A("s3a"),
        EMRFS("emrfs");

        private final String value;
        private static Map<String, Scheme> constants;

        private Scheme(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Scheme fromValue(String value) {
            Scheme constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, Scheme>();
            for (Scheme c : Scheme.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

