/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.filebuffer.test;

import java.io.File;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.core.StreamsResultSet;
import org.apache.streams.filebuffer.FileBufferConfiguration;
import org.apache.streams.filebuffer.FileBufferPersistReader;
import org.apache.streams.filebuffer.FileBufferPersistWriter;
import org.junit.Assert;
import org.junit.Test;

public class TestFileBufferPersist {
    private FileBufferConfiguration testConfiguration;

    @Test
    public void testPersistWriterString() {
        this.testConfiguration = new FileBufferConfiguration();
        this.testConfiguration.setPath("target/TestFilePersist.txt");
        File file = new File(this.testConfiguration.getPath());
        if (file.exists()) {
            file.delete();
        }
        FileBufferPersistWriter testPersistWriter = new FileBufferPersistWriter(this.testConfiguration);
        testPersistWriter.prepare((Object)this.testConfiguration);
        String testJsonString = "{\"dummy\":\"true\"}";
        testPersistWriter.write(new StreamsDatum((Object)testJsonString, "test"));
        testPersistWriter.cleanUp();
        FileBufferPersistReader testPersistReader = new FileBufferPersistReader(this.testConfiguration);
        try {
            testPersistReader.prepare((Object)this.testConfiguration);
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail();
        }
        StreamsResultSet testResult = testPersistReader.readCurrent();
        testPersistReader.cleanUp();
        assert (testResult.size() == 1);
    }
}

