/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.filebuffer.test;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import org.apache.streams.console.ConsolePersistReader;
import org.apache.streams.console.ConsolePersistWriter;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.core.StreamsPersistWriter;
import org.apache.streams.core.StreamsProvider;
import org.apache.streams.core.StreamsResultSet;
import org.apache.streams.filebuffer.FileBufferConfiguration;
import org.apache.streams.filebuffer.FileBufferPersistReader;
import org.apache.streams.filebuffer.FileBufferPersistWriter;
import org.apache.streams.local.builders.LocalStreamBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;

public class FileBufferPersistIT {
    private FileBufferConfiguration testConfiguration;
    ConsolePersistReader reader = (ConsolePersistReader)Mockito.mock(ConsolePersistReader.class);
    ConsolePersistWriter writer = (ConsolePersistWriter)Mockito.mock(ConsolePersistWriter.class);
    StreamsDatum testDatum1 = new StreamsDatum((Object)"{\"datum\":1}");
    StreamsDatum testDatum2 = new StreamsDatum((Object)"{\"datum\":2}");
    StreamsDatum testDatum3 = new StreamsDatum((Object)"{\"datum\":3}");

    @Before
    public void prepareTest() {
        this.testConfiguration = new FileBufferConfiguration();
        this.testConfiguration.setPath("target/FilePersistIT.txt");
        File file = new File(this.testConfiguration.getPath());
        if (file.exists()) {
            file.delete();
        }
        PowerMockito.when((Object)this.reader.readCurrent()).thenReturn((Object)new StreamsResultSet((Queue)Queues.newConcurrentLinkedQueue((Iterable)Lists.newArrayList((Object[])new StreamsDatum[]{this.testDatum1, this.testDatum2, this.testDatum3})))).thenReturn(null);
    }

    @Test
    public void testPersistStream() {
        assert (this.testConfiguration != null);
        HashMap streamConfig = Maps.newHashMap();
        streamConfig.put("TIMEOUT", 1000);
        LocalStreamBuilder builder = new LocalStreamBuilder(1, (Map)streamConfig);
        FileBufferPersistWriter fileWriter = new FileBufferPersistWriter(this.testConfiguration);
        FileBufferPersistReader fileReader = new FileBufferPersistReader(this.testConfiguration);
        builder.newReadCurrentStream("stdin", (StreamsProvider)this.reader);
        builder.addStreamsPersistWriter("writer", (StreamsPersistWriter)fileWriter, 1, new String[]{"stdin"});
        builder.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        builder.stop();
        builder = new LocalStreamBuilder(1, (Map)streamConfig);
        builder.newReadCurrentStream("reader", (StreamsProvider)fileReader);
        builder.addStreamsPersistWriter("stdout", (StreamsPersistWriter)this.writer, 1, new String[]{"reader"});
        builder.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        builder.stop();
        ((ConsolePersistWriter)Mockito.verify((Object)this.writer)).write(this.testDatum1);
        ((ConsolePersistWriter)Mockito.verify((Object)this.writer)).write(this.testDatum2);
        ((ConsolePersistWriter)Mockito.verify((Object)this.writer)).write(this.testDatum3);
    }

    @After
    public void shutdownTest() {
    }
}

