/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.elasticsearch.test;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Sets;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SerializationUtils;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.elasticsearch.processor.MetadataFromDocumentProcessor;
import org.apache.streams.jackson.StreamsJacksonMapper;
import org.apache.streams.pojo.json.Activity;
import org.apache.streams.pojo.json.ActivityObject;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMetadataFromDocumentProcessor {
    private static ObjectMapper MAPPER = StreamsJacksonMapper.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(TestMetadataFromDocumentProcessor.class);

    @Before
    public void prepareTest() {
    }

    @Test
    public void testSerializability() {
        MetadataFromDocumentProcessor processor = new MetadataFromDocumentProcessor();
        MetadataFromDocumentProcessor clone = (MetadataFromDocumentProcessor)SerializationUtils.clone((Serializable)processor);
    }

    @Test
    public void testMetadataFromDocumentProcessor() throws Exception {
        MetadataFromDocumentProcessor processor = new MetadataFromDocumentProcessor();
        processor.prepare(null);
        InputStream testActivityFolderStream = TestMetadataFromDocumentProcessor.class.getClassLoader().getResourceAsStream("activities");
        List files = IOUtils.readLines((InputStream)testActivityFolderStream, (Charset)Charsets.UTF_8);
        HashSet objects = Sets.newHashSet();
        for (String file : files) {
            LOGGER.info("File: " + file);
            InputStream testActivityFileStream = TestMetadataFromDocumentProcessor.class.getClassLoader().getResourceAsStream("activities/" + file);
            Activity activity = (Activity)MAPPER.readValue(testActivityFileStream, Activity.class);
            activity.setId(activity.getVerb());
            activity.getAdditionalProperties().remove("$license");
            if (activity.getActor().getObjectType() != null) {
                objects.add(activity.getActor());
            }
            if (activity.getObject().getObjectType() != null) {
                objects.add(activity.getObject());
            }
            StreamsDatum datum = new StreamsDatum((Object)activity);
            List resultList = processor.process(datum);
            assert (resultList != null);
            assert (resultList.size() == 1);
            StreamsDatum result = (StreamsDatum)resultList.get(0);
            assert (result != null);
            assert (result.getDocument() != null);
            assert (result.getId() != null);
            assert (result.getMetadata() != null);
            assert (result.getMetadata().get("id") != null);
            assert (result.getMetadata().get("type") != null);
            LOGGER.info("valid: " + activity.getVerb());
        }
        for (ActivityObject activityObject : objects) {
            LOGGER.info("Object: " + MAPPER.writeValueAsString((Object)activityObject));
            activityObject.setId(activityObject.getObjectType());
            StreamsDatum datum = new StreamsDatum((Object)activityObject);
            List resultList = processor.process(datum);
            assert (resultList != null);
            assert (resultList.size() == 1);
            StreamsDatum result = (StreamsDatum)resultList.get(0);
            assert (result != null);
            assert (result.getDocument() != null);
            assert (result.getId() != null);
            assert (result.getMetadata() != null);
            assert (result.getMetadata().get("id") != null);
            assert (result.getMetadata().get("type") != null);
            LOGGER.info("valid: " + activityObject.getObjectType());
        }
    }
}

