/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.elasticsearch.test;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Strings;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.elasticsearch.ElasticsearchPersistUpdater;
import org.apache.streams.elasticsearch.ElasticsearchPersistWriter;
import org.apache.streams.elasticsearch.ElasticsearchWriterConfiguration;
import org.apache.streams.jackson.StreamsJacksonMapper;
import org.apache.streams.pojo.json.Activity;
import org.apache.streams.pojo.json.ActivityObject;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequestBuilder;
import org.elasticsearch.action.count.CountRequest;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.test.ElasticsearchIntegrationTest;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@ElasticsearchIntegrationTest.ClusterScope(scope=ElasticsearchIntegrationTest.Scope.TEST, numNodes=1)
public class TestElasticsearchPersistWriterParentChildIT
extends ElasticsearchIntegrationTest {
    protected String TEST_INDEX = "TestElasticsearchPersistWriter".toLowerCase();
    private static final Logger LOGGER = LoggerFactory.getLogger(TestElasticsearchPersistWriterParentChildIT.class);
    private static ObjectMapper MAPPER = StreamsJacksonMapper.getInstance();
    protected ElasticsearchWriterConfiguration testConfiguration;
    Set<Class<? extends ActivityObject>> objectTypes;
    List<String> files;

    @Before
    public void prepareTest() throws Exception {
        this.testConfiguration = new ElasticsearchWriterConfiguration();
        this.testConfiguration.setHosts((List)Lists.newArrayList((Object[])new String[]{"localhost"}));
        this.testConfiguration.setClusterName(TestElasticsearchPersistWriterParentChildIT.cluster().getClusterName());
        this.testConfiguration.setIndex("activity");
        this.testConfiguration.setBatchSize(Long.valueOf(5L));
        PutIndexTemplateRequestBuilder putTemplateRequestBuilder = TestElasticsearchPersistWriterParentChildIT.client().admin().indices().preparePutTemplate("mappings");
        URL templateURL = TestElasticsearchPersistWriterParentChildIT.class.getResource("/ActivityChildObjectParent.json");
        ObjectNode template = (ObjectNode)MAPPER.readValue(templateURL, ObjectNode.class);
        String templateSource = MAPPER.writeValueAsString((Object)template);
        putTemplateRequestBuilder.setSource(templateSource);
        TestElasticsearchPersistWriterParentChildIT.client().admin().indices().putTemplate((PutIndexTemplateRequest)putTemplateRequestBuilder.request()).actionGet();
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)"org.apache.streams.pojo.json", (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new SubTypesScanner()}));
        this.objectTypes = reflections.getSubTypesOf(ActivityObject.class);
        InputStream testActivityFolderStream = TestElasticsearchPersistWriterParentChildIT.class.getClassLoader().getResourceAsStream("activities");
        this.files = IOUtils.readLines((InputStream)testActivityFolderStream, (Charset)Charsets.UTF_8);
    }

    @Test
    public void testPersist() throws Exception {
        this.testPersistWriter();
        this.testPersistUpdater();
    }

    void testPersistWriter() throws Exception {
        StreamsDatum datum;
        assert (!this.indexExists(this.TEST_INDEX));
        this.testConfiguration.setIndex("activity");
        this.testConfiguration.setBatchSize(Long.valueOf(5L));
        ElasticsearchPersistWriter testPersistWriter = new ElasticsearchPersistWriter(this.testConfiguration);
        testPersistWriter.prepare(null);
        for (Class<? extends ActivityObject> objectType : this.objectTypes) {
            ActivityObject object = objectType.newInstance();
            ActivityObject activityObject = (ActivityObject)MAPPER.convertValue((Object)object, ActivityObject.class);
            datum = new StreamsDatum((Object)activityObject, activityObject.getObjectType());
            datum.getMetadata().put("type", "object");
            testPersistWriter.write(datum);
        }
        for (String file : this.files) {
            LOGGER.info("File: " + file);
            InputStream testActivityFileStream = TestElasticsearchPersistWriterParentChildIT.class.getClassLoader().getResourceAsStream("activities/" + file);
            Activity activity = (Activity)MAPPER.readValue(testActivityFileStream, Activity.class);
            datum = new StreamsDatum((Object)activity, activity.getVerb());
            if (Strings.isNullOrEmpty((String)activity.getObject().getObjectType())) continue;
            datum.getMetadata().put("parent", activity.getObject().getObjectType());
            datum.getMetadata().put("type", "activity");
            testPersistWriter.write(datum);
            LOGGER.info("Wrote: " + activity.getVerb());
        }
        testPersistWriter.cleanUp();
        this.flushAndRefresh();
        long parent_count = ((CountResponse)TestElasticsearchPersistWriterParentChildIT.client().count((CountRequest)TestElasticsearchPersistWriterParentChildIT.client().prepareCount(new String[0]).setTypes(new String[]{"object"}).request()).actionGet()).getCount();
        TestElasticsearchPersistWriterParentChildIT.assertEquals((long)41L, (long)parent_count);
        long child_count = ((CountResponse)TestElasticsearchPersistWriterParentChildIT.client().count((CountRequest)TestElasticsearchPersistWriterParentChildIT.client().prepareCount(new String[0]).setTypes(new String[]{"activity"}).request()).actionGet()).getCount();
        TestElasticsearchPersistWriterParentChildIT.assertEquals((long)84L, (long)child_count);
    }

    void testPersistUpdater() throws Exception {
        ElasticsearchPersistUpdater testPersistUpdater = new ElasticsearchPersistUpdater(this.testConfiguration);
        testPersistUpdater.prepare(null);
        for (String file : this.files) {
            LOGGER.info("File: " + file);
            InputStream testActivityFileStream = TestElasticsearchPersistWriterParentChildIT.class.getClassLoader().getResourceAsStream("activities/" + file);
            Activity activity = (Activity)MAPPER.readValue(testActivityFileStream, Activity.class);
            activity.setAdditionalProperty("updated", (Object)Boolean.TRUE);
            StreamsDatum datum = new StreamsDatum((Object)activity, activity.getVerb());
            if (Strings.isNullOrEmpty((String)activity.getObject().getObjectType())) continue;
            datum.getMetadata().put("parent", activity.getObject().getObjectType());
            datum.getMetadata().put("type", "activity");
            testPersistUpdater.write(datum);
            LOGGER.info("Updated: " + activity.getVerb());
        }
        testPersistUpdater.cleanUp();
        this.flushAndRefresh();
        long child_count = ((CountResponse)TestElasticsearchPersistWriterParentChildIT.client().count((CountRequest)TestElasticsearchPersistWriterParentChildIT.client().prepareCount(new String[0]).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"updated", (String)"true")).setTypes(new String[]{"activity"}).request()).actionGet()).getCount();
        TestElasticsearchPersistWriterParentChildIT.assertEquals((long)84L, (long)child_count);
    }
}

