/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.elasticsearch.test;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import org.apache.commons.lang.SerializationUtils;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.elasticsearch.processor.DocumentToMetadataProcessor;
import org.apache.streams.jackson.StreamsJacksonMapper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDocumentToMetadataProcessor {
    private static ObjectMapper MAPPER = StreamsJacksonMapper.getInstance();

    @Before
    public void prepareTest() {
    }

    @Test
    public void testSerializability() {
        DocumentToMetadataProcessor processor = new DocumentToMetadataProcessor();
        DocumentToMetadataProcessor clone = (DocumentToMetadataProcessor)SerializationUtils.clone((Serializable)processor);
    }

    @Test
    public void testDocumentToMetadataProcessor() {
        ObjectNode document = MAPPER.createObjectNode().put("a", "a").put("b", "b").put("c", 6);
        DocumentToMetadataProcessor processor = new DocumentToMetadataProcessor();
        StreamsDatum testInput = new StreamsDatum((Object)document);
        Assert.assertNotNull((Object)testInput.document);
        Assert.assertNotNull((Object)testInput.metadata);
        Assert.assertEquals((long)testInput.metadata.size(), (long)0L);
        processor.prepare(null);
        StreamsDatum testOutput = (StreamsDatum)processor.process(testInput).get(0);
        processor.cleanUp();
        Assert.assertNotNull((Object)testOutput.metadata);
        Assert.assertEquals((long)testInput.metadata.size(), (long)3L);
    }
}

