/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.elasticsearch.test;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.SerializationUtils;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.elasticsearch.ElasticsearchReaderConfiguration;
import org.apache.streams.elasticsearch.processor.DatumFromMetadataProcessor;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.test.ElasticsearchIntegrationTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@ElasticsearchIntegrationTest.ClusterScope(scope=ElasticsearchIntegrationTest.Scope.TEST, numNodes=1)
public class TestDatumFromMetadataProcessor
extends ElasticsearchIntegrationTest {
    private final String TEST_INDEX = "TestDatumFromMetadataProcessor".toLowerCase();
    private ElasticsearchReaderConfiguration testConfiguration;

    @Test
    public void testSerializability() {
        DatumFromMetadataProcessor processor = new DatumFromMetadataProcessor(this.testConfiguration);
        DatumFromMetadataProcessor clone = (DatumFromMetadataProcessor)SerializationUtils.clone((Serializable)processor);
    }

    @Before
    public void prepareTest() {
        this.testConfiguration = new ElasticsearchReaderConfiguration();
        this.testConfiguration.setHosts((List)Lists.newArrayList((Object[])new String[]{"localhost"}));
        this.testConfiguration.setClusterName(TestDatumFromMetadataProcessor.cluster().getClusterName());
        String testJsonString = "{\"dummy\":\"true\"}";
        TestDatumFromMetadataProcessor.client().index((IndexRequest)TestDatumFromMetadataProcessor.client().prepareIndex(this.TEST_INDEX, "activity", "id").setSource(testJsonString).request()).actionGet(5L, TimeUnit.SECONDS);
    }

    @Test
    public void testDatumFromMetadataProcessor() {
        HashMap metadata = Maps.newHashMap();
        metadata.put("index", this.TEST_INDEX);
        metadata.put("type", "activity");
        metadata.put("id", "id");
        DatumFromMetadataProcessor processor = new DatumFromMetadataProcessor(this.testConfiguration);
        StreamsDatum testInput = new StreamsDatum(null);
        testInput.setMetadata((Map)metadata);
        Assert.assertNull((Object)testInput.document);
        processor.prepare(null);
        StreamsDatum testOutput = (StreamsDatum)processor.process(testInput).get(0);
        processor.cleanUp();
        Assert.assertNotNull((Object)testOutput.document);
    }
}

