/*
 * Decompiled with CFR 0.152.
 */
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.streams.components.http.HttpPersistWriterConfiguration;
import org.apache.streams.components.http.persist.SimpleHTTPPostPersistWriter;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.jackson.StreamsJacksonMapper;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={HttpClients.class, CloseableHttpResponse.class, CloseableHttpResponse.class})
public class SimpleHTTPPostPersistWriterTest {
    private ObjectMapper mapper = StreamsJacksonMapper.getInstance();
    private static final int PORT = 18080;
    private static final String HOSTNAME = "localhost";
    private static final String PROTOCOL = "http";
    private CloseableHttpClient client;
    private CloseableHttpResponse response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
    private ByteArrayOutputStream output;
    private ByteArrayInputStream input;

    @Before
    public void setUp() throws Exception {
        this.client = (CloseableHttpClient)PowerMockito.mock(CloseableHttpClient.class);
        PowerMockito.mockStatic(HttpClients.class, (Class[])new Class[0]);
        PowerMockito.when((Object)HttpClients.createDefault()).thenReturn((Object)this.client);
        PowerMockito.when((Object)this.client.execute((HttpUriRequest)Matchers.any(HttpUriRequest.class))).thenReturn((Object)this.response);
        Mockito.when((Object)this.response.getEntity()).thenReturn(null);
        ((CloseableHttpResponse)Mockito.doNothing().when((Object)this.response)).close();
    }

    @Test
    public void testPersist() throws Exception {
        HttpPersistWriterConfiguration configuration = new HttpPersistWriterConfiguration();
        configuration.setProtocol(PROTOCOL);
        configuration.setHostname(HOSTNAME);
        configuration.setPort(Long.valueOf(18080L));
        configuration.setResourcePath("/");
        SimpleHTTPPostPersistWriter writer = new SimpleHTTPPostPersistWriter(configuration);
        writer.prepare(null);
        StreamsDatum testDatum = new StreamsDatum(this.mapper.readValue("{\"message\":\"ping\"}", ObjectNode.class));
        writer.write(testDatum);
        ((CloseableHttpClient)Mockito.verify((Object)this.client)).execute((HttpUriRequest)Matchers.any(HttpUriRequest.class));
        ((CloseableHttpResponse)Mockito.verify((Object)this.response)).close();
    }
}

