/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.plugins.test;

import java.io.File;
import java.io.FileFilter;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.streams.plugins.StreamsScalaGenerationConfig;
import org.apache.streams.plugins.StreamsScalaSourceGenerator;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamsScalaSourceGeneratorTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamsScalaSourceGeneratorTest.class);
    public static final String[] scalaFilter = new String[]{"scala"};

    @Test
    public void testStreamsScalaSourceGenerator() throws Exception {
        StreamsScalaGenerationConfig streamsScalaGenerationConfig = new StreamsScalaGenerationConfig();
        streamsScalaGenerationConfig.setSourcePackages(Stream.of("org.apache.streams.pojo.json").collect(Collectors.toList()));
        streamsScalaGenerationConfig.setTargetPackage("org.apache.streams.scala");
        streamsScalaGenerationConfig.setTargetDirectory("target/generated-sources/scala-test");
        StreamsScalaSourceGenerator streamsScalaSourceGenerator = new StreamsScalaSourceGenerator(streamsScalaGenerationConfig);
        streamsScalaSourceGenerator.run();
        File testOutput = new File("./target/generated-sources/scala-test/org/apache/streams/scala");
        FileFilter scalaFilter = pathname -> pathname.getName().endsWith(".scala");
        Assert.assertNotNull((Object)testOutput);
        Assert.assertTrue((boolean)testOutput.exists());
        Assert.assertTrue((boolean)testOutput.isDirectory());
        Assert.assertEquals((long)17L, (long)testOutput.listFiles(scalaFilter).length);
        Assert.assertTrue((boolean)new File(testOutput + "/traits").exists());
        Assert.assertTrue((boolean)new File(testOutput + "/traits").isDirectory());
        Assert.assertNotNull((Object)new File(testOutput + "/traits").listFiles(scalaFilter));
        Assert.assertEquals((long)4L, (long)new File(testOutput + "/traits").listFiles(scalaFilter).length);
        Assert.assertTrue((boolean)new File(testOutput + "/objectTypes").exists());
        Assert.assertTrue((boolean)new File(testOutput + "/objectTypes").isDirectory());
        Assert.assertNotNull((Object)new File(testOutput + "/objectTypes").listFiles(scalaFilter));
        Assert.assertEquals((long)48L, (long)new File(testOutput + "/objectTypes").listFiles(scalaFilter).length);
        Assert.assertTrue((boolean)new File(testOutput + "/verbs").exists());
        Assert.assertTrue((boolean)new File(testOutput + "/verbs").isDirectory());
        Assert.assertNotNull((Object)new File(testOutput + "/verbs").listFiles(scalaFilter));
        Assert.assertEquals((long)89L, (long)new File(testOutput + "/verbs").listFiles(scalaFilter).length);
    }
}

