/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.plugins.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.maven.shared.verifier.Verifier;
import org.apache.maven.shared.verifier.util.ResourceExtractor;
import org.apache.streams.plugins.test.StreamsScalaSourceGeneratorTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class StreamsScalaSourceGeneratorMojoIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamsScalaSourceGeneratorMojoIT.class);

    @Test
    public void testStreamsScalaSourceGeneratorMojo() throws Exception {
        File testDir = ResourceExtractor.simpleExtractResources(this.getClass(), (String)"/streams-plugin-scala");
        Verifier verifier = new Verifier(testDir.getAbsolutePath());
        ArrayList<String> cliOptions = new ArrayList<String>();
        cliOptions.add("-N");
        verifier.executeGoals(Stream.of("compile").collect(Collectors.toList()));
        verifier.verifyErrorFreeLog();
        verifier.resetStreams();
        File testOutput = new File(testDir.getAbsolutePath() + "/target/generated-sources/scala-mojo");
        Assert.assertNotNull((Object)testOutput);
        Assert.assertTrue((boolean)testOutput.exists());
        Assert.assertTrue((boolean)testOutput.isDirectory());
        Collection outputCollection = FileUtils.listFiles((File)testOutput, (String[])StreamsScalaSourceGeneratorTest.scalaFilter, (boolean)true);
        assert (outputCollection.size() > 133);
    }
}

