/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.plugins.elasticsearch;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.streams.plugins.elasticsearch.StreamsElasticsearchGenerationConfig;
import org.apache.streams.plugins.elasticsearch.StreamsElasticsearchResourceGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="generate-resources", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
@Execute(goal="generate-resources", phase=LifecyclePhase.GENERATE_RESOURCES)
public class StreamsElasticsearchResourceGeneratorMojo
extends AbstractMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamsElasticsearchResourceGeneratorMojo.class);
    private volatile MojoFailureException mojoFailureException;
    @Component
    private MavenProject project;
    @Parameter(defaultValue="${project.basedir}", readonly=true)
    private File basedir;
    @Parameter(defaultValue="src/main/jsonschema", readonly=true)
    public String sourceDirectory;
    @Parameter(readonly=true)
    public List<String> sourcePaths;
    @Parameter(defaultValue="./target/generated-resources/streams-plugin-elasticsearch", readonly=true)
    public String targetDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        StreamsElasticsearchGenerationConfig config = new StreamsElasticsearchGenerationConfig();
        if (this.sourcePaths != null && this.sourcePaths.size() > 0) {
            config.setSourcePaths(this.sourcePaths);
        } else {
            config.setSourceDirectory(this.sourceDirectory);
        }
        config.setTargetDirectory(this.targetDirectory);
        StreamsElasticsearchResourceGenerator streamsElasticsearchResourceGenerator = new StreamsElasticsearchResourceGenerator(config);
        streamsElasticsearchResourceGenerator.run();
    }
}

