/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.plugins.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.streams.jackson.StreamsJacksonMapper;
import org.apache.streams.plugins.elasticsearch.StreamsElasticsearchGenerationConfig;
import org.apache.streams.util.schema.FieldType;
import org.apache.streams.util.schema.FieldUtil;
import org.apache.streams.util.schema.FileUtil;
import org.apache.streams.util.schema.GenerationConfig;
import org.apache.streams.util.schema.Schema;
import org.apache.streams.util.schema.SchemaStore;
import org.apache.streams.util.schema.SchemaStoreImpl;
import org.jsonschema2pojo.util.URLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamsElasticsearchResourceGenerator
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamsElasticsearchResourceGenerator.class);
    private static final ObjectMapper MAPPER = StreamsJacksonMapper.getInstance();
    private static final String LS = System.getProperty("line.separator");
    private StreamsElasticsearchGenerationConfig config;
    private SchemaStore schemaStore = new SchemaStoreImpl();
    private int currentDepth = 0;

    public static void main(String[] args) {
        StreamsElasticsearchGenerationConfig config = new StreamsElasticsearchGenerationConfig();
        String sourceDirectory = "src/main/jsonschema";
        String targetDirectory = "target/generated-resources/streams-plugin-elasticsearch";
        if (args.length > 0) {
            sourceDirectory = args[0];
        }
        if (args.length > 1) {
            targetDirectory = args[1];
        }
        config.setSourceDirectory(sourceDirectory);
        config.setTargetDirectory(targetDirectory);
        StreamsElasticsearchResourceGenerator streamsElasticsearchResourceGenerator = new StreamsElasticsearchResourceGenerator(config);
        streamsElasticsearchResourceGenerator.run();
    }

    public StreamsElasticsearchResourceGenerator(StreamsElasticsearchGenerationConfig config) {
        this.config = config;
    }

    @Override
    public void run() {
        Objects.requireNonNull(this.config);
        this.generate(this.config);
    }

    public void generate(StreamsElasticsearchGenerationConfig config) {
        LinkedList<File> sourceFiles = new LinkedList<File>();
        Iterator<URL> sources = config.getSource();
        while (sources.hasNext()) {
            URL source = sources.next();
            sourceFiles.add(URLUtil.getFileFromURL((URL)source));
        }
        LOGGER.info("Seeded with {} source paths:", (Object)sourceFiles.size());
        FileUtil.resolveRecursive((GenerationConfig)config, sourceFiles);
        LOGGER.info("Resolved {} schema files:", (Object)sourceFiles.size());
        for (File item : sourceFiles) {
            this.schemaStore.create(item.toURI());
        }
        LOGGER.info("Identified {} objects:", (Object)this.schemaStore.getSize());
        Iterator schemaIterator = this.schemaStore.getSchemaIterator();
        while (schemaIterator.hasNext()) {
            Schema schema = (Schema)schemaIterator.next();
            this.currentDepth = 0;
            if (!schema.getUri().getScheme().equals("file")) continue;
            String inputFile = schema.getUri().getPath();
            String resourcePath = FileUtil.dropSourcePathPrefix((String)inputFile, (String)config.getSourceDirectory());
            for (String sourcePath : config.getSourcePaths()) {
                resourcePath = FileUtil.dropSourcePathPrefix((String)resourcePath, (String)sourcePath);
            }
            String outputFile = config.getTargetDirectory() + "/" + resourcePath;
            LOGGER.info("Processing {}:", (Object)resourcePath);
            String resourceId = this.schemaSymbol(schema);
            String resourceContent = this.generateResource(schema, resourceId);
            if (StringUtils.isNotBlank((CharSequence)resourceContent)) {
                FileUtil.writeFile((String)outputFile, (String)resourceContent);
            }
            LOGGER.info("Wrote {}:", (Object)outputFile);
        }
    }

    public String generateResource(Schema schema, String resourceId) {
        StringBuilder resourceBuilder = new StringBuilder();
        ObjectNode rootNode = (ObjectNode)schema.getContent();
        try {
            String objectString = MAPPER.writeValueAsString((Object)rootNode);
            resourceBuilder.append(objectString);
        }
        catch (JsonProcessingException ex) {
            LOGGER.error("{}: {}", (Object)((Object)((Object)ex)).getClass().getName(), (Object)ex);
        }
        return resourceBuilder.toString();
    }

    protected StringBuilder appendRootObject(StringBuilder builder, Schema schema, String resourceId, Character seperator) {
        ObjectNode propertiesNode = this.schemaStore.resolveProperties(schema, null, resourceId);
        if (propertiesNode.get("id") != null) {
            builder.append("id text PRIMARY KEY,");
            builder.append(LS);
            propertiesNode.remove("id");
        }
        if (propertiesNode.isObject() && propertiesNode.size() > 0) {
            builder = this.appendPropertiesNode(builder, schema, propertiesNode, seperator);
        }
        return builder;
    }

    private StringBuilder appendValueField(StringBuilder builder, Schema schema, String fieldId, FieldType fieldType, Character seperator) {
        Objects.requireNonNull(builder);
        builder.append(StreamsElasticsearchResourceGenerator.cqlEscape(fieldId));
        builder.append(seperator);
        builder.append(StreamsElasticsearchResourceGenerator.cqlType(fieldType));
        return builder;
    }

    protected StringBuilder appendArrayItems(StringBuilder builder, Schema schema, String fieldId, ObjectNode itemsNode, Character seperator) {
        Objects.requireNonNull(builder);
        if (itemsNode == null) {
            return builder;
        }
        if (itemsNode.has("type")) {
            try {
                FieldType itemType = FieldUtil.determineFieldType((ObjectNode)itemsNode);
                switch (itemType) {
                    case OBJECT: {
                        Schema objectSchema = null;
                        URI parentUri = null;
                        if (itemsNode.has("$ref") || itemsNode.has("extends")) {
                            Optional schemaLookup;
                            URI absoluteUri;
                            JsonNode refNode = itemsNode.get("$ref");
                            JsonNode extendsNode = itemsNode.get("extends");
                            if (refNode != null && refNode.isValueNode()) {
                                parentUri = URI.create(refNode.asText());
                            } else if (extendsNode != null && extendsNode.isObject()) {
                                parentUri = URI.create(extendsNode.get("$ref").asText());
                            }
                            if (parentUri.isAbsolute()) {
                                absoluteUri = parentUri;
                            } else {
                                absoluteUri = schema.getUri().resolve(parentUri);
                                if (!absoluteUri.isAbsolute() || absoluteUri.isAbsolute() && !this.schemaStore.getByUri(absoluteUri).isPresent()) {
                                    absoluteUri = schema.getParentUri().resolve(parentUri);
                                }
                            }
                            if (absoluteUri.isAbsolute() && (schemaLookup = this.schemaStore.getByUri(absoluteUri)).isPresent()) {
                                objectSchema = (Schema)schemaLookup.get();
                            }
                        }
                        builder = this.appendArrayObject(builder, objectSchema, fieldId, seperator);
                        break;
                    }
                    case ARRAY: {
                        ObjectNode subArrayItems = (ObjectNode)itemsNode.get("items");
                        builder = this.appendArrayItems(builder, schema, fieldId, subArrayItems, seperator);
                        break;
                    }
                    default: {
                        builder = this.appendArrayField(builder, schema, fieldId, itemType, seperator);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.warn("No item type resolvable for {}", (Object)fieldId);
            }
        }
        Objects.requireNonNull(builder);
        return builder;
    }

    private StringBuilder appendArrayField(StringBuilder builder, Schema schema, String fieldId, FieldType fieldType, Character seperator) {
        Objects.requireNonNull(builder);
        Objects.requireNonNull(fieldId);
        builder.append(StreamsElasticsearchResourceGenerator.cqlEscape(fieldId));
        builder.append(seperator);
        builder.append("list<").append(StreamsElasticsearchResourceGenerator.cqlType(fieldType)).append(">");
        Objects.requireNonNull(builder);
        return builder;
    }

    private StringBuilder appendArrayObject(StringBuilder builder, Schema schema, String fieldId, Character seperator) {
        Objects.requireNonNull(builder);
        String schemaSymbol = this.schemaSymbol(schema);
        if (StringUtils.isNotBlank((CharSequence)fieldId) && schemaSymbol != null) {
            builder.append(StreamsElasticsearchResourceGenerator.cqlEscape(fieldId));
            builder.append(seperator);
            builder.append("list<").append(schemaSymbol).append(">");
            builder.append(LS);
        }
        Objects.requireNonNull(builder);
        return builder;
    }

    private StringBuilder appendSchemaField(StringBuilder builder, Schema schema, String fieldId, Character seperator) {
        Objects.requireNonNull(builder);
        String schemaSymbol = this.schemaSymbol(schema);
        if (StringUtils.isNotBlank((CharSequence)fieldId) && schemaSymbol != null) {
            builder.append(StreamsElasticsearchResourceGenerator.cqlEscape(fieldId));
            builder.append(seperator);
            builder.append(schemaSymbol);
        }
        Objects.requireNonNull(builder);
        return builder;
    }

    private StringBuilder appendPropertiesNode(StringBuilder builder, Schema schema, ObjectNode propertiesNode, Character seperator) {
        Objects.requireNonNull(builder);
        Objects.requireNonNull(propertiesNode);
        Iterator fields = propertiesNode.fields();
        ArrayList<String> fieldStrings = new ArrayList<String>();
        block4: while (fields.hasNext()) {
            ObjectNode fieldNode;
            FieldType fieldType;
            Map.Entry field = (Map.Entry)fields.next();
            String fieldId = (String)field.getKey();
            if (this.config.getExclusions().contains(fieldId) || !((JsonNode)field.getValue()).isObject() || (fieldType = FieldUtil.determineFieldType((ObjectNode)(fieldNode = (ObjectNode)field.getValue()))) == null) continue;
            switch (fieldType) {
                case ARRAY: {
                    StringBuilder arrayItemsBuilder;
                    ObjectNode itemsNode = (ObjectNode)fieldNode.get("items");
                    if (this.currentDepth > this.config.getMaxDepth() || !StringUtils.isNotBlank((CharSequence)(arrayItemsBuilder = this.appendArrayItems(new StringBuilder(), schema, fieldId, itemsNode, seperator)).toString())) continue block4;
                    fieldStrings.add(arrayItemsBuilder.toString());
                    break;
                }
                case OBJECT: {
                    StringBuilder structFieldBuilder;
                    Schema objectSchema = null;
                    URI parentUri = null;
                    if (fieldNode.has("$ref") || fieldNode.has("extends")) {
                        Optional schemaLookup;
                        URI absoluteUri;
                        JsonNode refNode = fieldNode.get("$ref");
                        JsonNode extendsNode = fieldNode.get("extends");
                        if (refNode != null && refNode.isValueNode()) {
                            parentUri = URI.create(refNode.asText());
                        } else if (extendsNode != null && extendsNode.isObject()) {
                            parentUri = URI.create(extendsNode.get("$ref").asText());
                        }
                        if (parentUri.isAbsolute()) {
                            absoluteUri = parentUri;
                        } else {
                            absoluteUri = schema.getUri().resolve(parentUri);
                            if (!absoluteUri.isAbsolute() || absoluteUri.isAbsolute() && !this.schemaStore.getByUri(absoluteUri).isPresent()) {
                                absoluteUri = schema.getParentUri().resolve(parentUri);
                            }
                        }
                        if (absoluteUri.isAbsolute() && (schemaLookup = this.schemaStore.getByUri(absoluteUri)).isPresent()) {
                            objectSchema = (Schema)schemaLookup.get();
                        }
                    }
                    if (this.currentDepth >= this.config.getMaxDepth() || !StringUtils.isNotBlank((CharSequence)(structFieldBuilder = this.appendSchemaField(new StringBuilder(), objectSchema, fieldId, seperator)).toString())) continue block4;
                    fieldStrings.add(structFieldBuilder.toString());
                    break;
                }
                default: {
                    StringBuilder valueFieldBuilder = this.appendValueField(new StringBuilder(), schema, fieldId, fieldType, seperator);
                    if (!StringUtils.isNotBlank((CharSequence)valueFieldBuilder.toString())) continue block4;
                    fieldStrings.add(valueFieldBuilder.toString());
                }
            }
        }
        builder.append(String.join((CharSequence)("," + LS), fieldStrings)).append(LS);
        Objects.requireNonNull(builder);
        return builder;
    }

    private static String cqlEscape(String fieldId) {
        return "`" + fieldId + "`";
    }

    private static String cqlType(FieldType fieldType) {
        switch (fieldType) {
            case STRING: {
                return "text";
            }
            case INTEGER: {
                return "int";
            }
            case NUMBER: {
                return "double";
            }
            case OBJECT: {
                return "tuple";
            }
            case ARRAY: {
                return "list";
            }
        }
        return fieldType.name().toUpperCase();
    }

    private String schemaSymbol(Schema schema) {
        if (schema == null) {
            return null;
        }
        if (schema.getUri().getScheme().equals("file")) {
            String inputFile = schema.getUri().getPath();
            String resourcePath = FileUtil.dropSourcePathPrefix((String)inputFile, (String)this.config.getSourceDirectory());
            for (String sourcePath : this.config.getSourcePaths()) {
                resourcePath = FileUtil.dropSourcePathPrefix((String)resourcePath, (String)sourcePath);
            }
            return FileUtil.dropExtension((String)resourcePath).replace("/", "_");
        }
        return "IDK";
    }
}

