/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.plugins.elasticsearch;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.streams.util.schema.GenerationConfig;
import org.jsonschema2pojo.DefaultGenerationConfig;
import org.jsonschema2pojo.util.URLUtil;

public class StreamsElasticsearchGenerationConfig
extends DefaultGenerationConfig
implements GenerationConfig {
    private String sourceDirectory;
    private List<String> sourcePaths = new ArrayList<String>();
    private String targetDirectory;
    private int maxDepth = 1;
    private Set<String> exclusions = new HashSet<String>();

    public String getSourceDirectory() {
        return this.sourceDirectory;
    }

    public List<String> getSourcePaths() {
        return this.sourcePaths;
    }

    public Set<String> getExclusions() {
        return this.exclusions;
    }

    public void setExclusions(Set<String> exclusions) {
        this.exclusions = exclusions;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setSourceDirectory(String sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public void setSourcePaths(List<String> sourcePaths) {
        this.sourcePaths = sourcePaths;
    }

    public void setTargetDirectory(String targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public File getTargetDirectory() {
        return new File(this.targetDirectory);
    }

    public Iterator<URL> getSource() {
        if (null != this.sourceDirectory) {
            return Collections.singleton(URLUtil.parseURL((String)this.sourceDirectory)).iterator();
        }
        ArrayList<URL> sourceUrls = new ArrayList<URL>();
        if (this.sourcePaths != null && this.sourcePaths.size() > 0) {
            for (String source : this.sourcePaths) {
                sourceUrls.add(URLUtil.parseURL((String)source));
            }
        }
        return sourceUrls.iterator();
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }
}

