/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.plugins.elasticsearch.test;

import java.io.File;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.streams.plugins.elasticsearch.StreamsElasticsearchGenerationConfig;
import org.apache.streams.plugins.elasticsearch.StreamsElasticsearchResourceGenerator;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamsElasticsearchResourceGeneratorTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamsElasticsearchResourceGeneratorTest.class);
    public static final String[] jsonFilter = new String[]{"json"};

    @Test
    public void StreamsElasticsearchResourceGenerator() throws Exception {
        StreamsElasticsearchGenerationConfig config = new StreamsElasticsearchGenerationConfig();
        String sourceDirectory = "target/test-classes/activitystreams-schemas";
        config.setSourceDirectory(sourceDirectory);
        config.setTargetDirectory("target/generated-resources/elasticsearch");
        config.setExclusions(Stream.of("attachments").collect(Collectors.toSet()));
        config.setMaxDepth(2);
        StreamsElasticsearchResourceGenerator streamsElasticsearchResourceGenerator = new StreamsElasticsearchResourceGenerator(config);
        streamsElasticsearchResourceGenerator.run();
        File testOutput = config.getTargetDirectory();
        Assert.assertNotNull((Object)testOutput);
        Assert.assertTrue((boolean)testOutput.exists());
        Assert.assertTrue((boolean)testOutput.isDirectory());
        Collection outputCollection = FileUtils.listFiles((File)testOutput, (String[])jsonFilter, (boolean)true);
        Assert.assertEquals((long)outputCollection.size(), (long)133L);
    }
}

