/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.example;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.streams.config.ComponentConfigurator;
import org.apache.streams.config.StreamsConfigurator;
import org.apache.streams.core.StreamsPersistWriter;
import org.apache.streams.core.StreamsProvider;
import org.apache.streams.elasticsearch.ElasticsearchPersistWriter;
import org.apache.streams.example.MongoElasticsearchSyncConfiguration;
import org.apache.streams.local.builders.LocalStreamBuilder;
import org.apache.streams.mongo.MongoPersistReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoElasticsearchSync
implements Runnable {
    public static final String STREAMS_ID = "MongoElasticsearchSync";
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoElasticsearchSync.class);
    MongoElasticsearchSyncConfiguration config;

    public MongoElasticsearchSync() {
        this((MongoElasticsearchSyncConfiguration)new ComponentConfigurator(MongoElasticsearchSyncConfiguration.class).detectConfiguration(StreamsConfigurator.getConfig()));
    }

    public MongoElasticsearchSync(MongoElasticsearchSyncConfiguration config) {
        this.config = config;
    }

    public static void main(String[] args) {
        LOGGER.info(StreamsConfigurator.config.toString());
        MongoElasticsearchSync sync = new MongoElasticsearchSync();
        new Thread(sync).start();
    }

    @Override
    public void run() {
        MongoPersistReader mongoPersistReader = new MongoPersistReader(this.config.getSource());
        ElasticsearchPersistWriter elasticsearchPersistWriter = new ElasticsearchPersistWriter(this.config.getDestination());
        HashMap streamConfig = Maps.newHashMap();
        streamConfig.put("streamsID", STREAMS_ID);
        streamConfig.put("TIMEOUT", 10080000);
        LocalStreamBuilder builder = new LocalStreamBuilder(1000, (Map)streamConfig);
        builder.newPerpetualStream("MongoPersistReader", (StreamsProvider)mongoPersistReader);
        builder.addStreamsPersistWriter(ElasticsearchPersistWriter.STREAMS_ID, (StreamsPersistWriter)elasticsearchPersistWriter, 1, new String[]{"MongoPersistReader"});
        builder.start();
    }
}

