/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.gnip.powertrack;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.apache.streams.data.ActivitySerializer;
import org.apache.streams.pojo.json.Activity;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerTrackActivitySerializer
implements ActivitySerializer<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PowerTrackActivitySerializer.class);
    private ObjectMapper mapper = new ObjectMapper();

    public PowerTrackActivitySerializer() {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, Boolean.FALSE.booleanValue());
        this.mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, Boolean.TRUE.booleanValue());
        this.mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, Boolean.TRUE.booleanValue());
    }

    public String serializationFormat() {
        return "gnip_powertrack";
    }

    public String serialize(Activity deserialized) {
        throw new UnsupportedOperationException();
    }

    public Activity deserialize(String serialized) {
        Activity activity = null;
        try {
            String url;
            JSONObject actor;
            String dateTime;
            JSONObject object;
            JSONObject jsonObject = new JSONObject(serialized);
            String content = jsonObject.optString("content", null);
            if (content == null && (content = jsonObject.optString("body", null)) == null && (content = jsonObject.optString("summary", null)) == null && (object = jsonObject.optJSONObject("object")) != null && (content = object.optString("content", null)) == null && (content = object.optString("body", null)) == null) {
                content = object.optString("summary", null);
            }
            if (content != null) {
                jsonObject.put("content", (Object)content);
            }
            if ((dateTime = jsonObject.optString("postedTime")) != null) {
                jsonObject.put("published", (Object)dateTime);
            }
            if ((actor = jsonObject.optJSONObject("actor")) != null && (url = actor.optString("image")) != null) {
                JSONObject media = new JSONObject();
                media.put("url", (Object)url);
                actor.put("image", (Object)media);
            }
            serialized = jsonObject.toString();
            StringReader reader = new StringReader(serialized);
            activity = (Activity)this.mapper.readValue((Reader)reader, Activity.class);
        }
        catch (Exception e) {
            LOGGER.error("Exception deserializing powertrack string to Activity Object.", (Throwable)e);
            LOGGER.error("Exception on json : {}", (Object)serialized);
        }
        return activity;
    }

    public List<Activity> deserializeAll(List<String> serializedList) {
        throw new NotImplementedException("Not currently supported by this deserializer");
    }
}

