/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.gnip.powertrack;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.streams.pojo.json.Activity;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GnipActivityFixer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GnipActivityFixer.class);
    private ObjectMapper mapper = new ObjectMapper();
    private XmlMapper xmlMapper;

    public GnipActivityFixer() {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, Boolean.FALSE.booleanValue());
        this.mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, Boolean.TRUE.booleanValue());
        this.mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, Boolean.TRUE.booleanValue());
        this.xmlMapper = new XmlMapper();
        this.xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, Boolean.FALSE.booleanValue());
        this.xmlMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, Boolean.TRUE.booleanValue());
        this.xmlMapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, Boolean.TRUE.booleanValue());
    }

    public static void findNullContents(JSONObject json, ArrayList<String> drilldownKeys, HashMap<ArrayList<String>, JSONObject> nullContents) throws Exception {
        Iterator itr = json.keys();
        while (itr.hasNext()) {
            block5: {
                String element = (String)itr.next();
                if (StringUtils.isBlank((String)element)) {
                    nullContents.put(drilldownKeys, json);
                } else {
                    try {
                        drilldownKeys.add(element);
                        if (!(json.get(element) instanceof JSONObject)) break block5;
                        GnipActivityFixer.findNullContents((JSONObject)json.get(element), drilldownKeys, nullContents);
                    }
                    catch (Exception e) {
                        LOGGER.info("Failed to convert in findNullKeys, " + e);
                        LOGGER.error("Element : {}", (Object)element);
                        LOGGER.error(json.toString());
                        break;
                    }
                }
            }
            drilldownKeys = new ArrayList();
        }
    }

    public static void editJson(JSONObject json, ArrayList<String> keyPath, Object nullFragment) throws JSONException {
        Integer numKeys = keyPath.size();
        JSONObject newJson = new JSONObject();
        if (numKeys > 1) {
            for (int i = numKeys - 1; i > 0; --i) {
                String key = keyPath.get(i);
                newJson = i == numKeys - 1 ? newJson.put(key, nullFragment) : newJson.put(key, (Object)newJson);
            }
            json.put(keyPath.get(0), (Object)newJson);
        } else {
            json.put(keyPath.get(0), nullFragment);
        }
    }

    public static Activity fix(Activity activity) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String des = mapper.writeValueAsString((Object)activity);
        JSONObject json = new JSONObject(des);
        HashMap<ArrayList<String>, JSONObject> nullContents = new HashMap<ArrayList<String>, JSONObject>();
        ArrayList<String> drilldownKeys = new ArrayList<String>();
        GnipActivityFixer.findNullContents(json, drilldownKeys, nullContents);
        for (Map.Entry<ArrayList<String>, JSONObject> entry : nullContents.entrySet()) {
            JSONObject frag = entry.getValue();
            GnipActivityFixer.editJson(json, entry.getKey(), frag.get(""));
        }
        StringReader str = new StringReader(json.toString());
        Activity testAct = null;
        try {
            testAct = (Activity)mapper.readValue((Reader)str, Activity.class);
        }
        catch (Exception e) {
            LOGGER.error("Exception creating activity.", (Throwable)e);
            LOGGER.error("JSON : {}" + json.toString());
        }
        return testAct;
    }

    public static JSONObject fix(JSONObject json) throws Exception {
        HashMap<ArrayList<String>, JSONObject> nullContents = new HashMap<ArrayList<String>, JSONObject>();
        ArrayList<String> drilldownKeys = new ArrayList<String>();
        GnipActivityFixer.findNullContents(json, drilldownKeys, nullContents);
        for (Map.Entry<ArrayList<String>, JSONObject> entry : nullContents.entrySet()) {
            JSONObject frag = entry.getValue();
            GnipActivityFixer.editJson(json, entry.getKey(), frag.get(""));
        }
        return json;
    }
}

