/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.gnip.powertrack;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.streams.data.ActivitySerializer;
import org.apache.streams.pojo.json.Activity;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ActivityXMLActivitySerializer
implements ActivitySerializer<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivityXMLActivitySerializer.class);
    private ObjectMapper mapper = new ObjectMapper();
    private XmlMapper xmlMapper;

    public ActivityXMLActivitySerializer() {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, Boolean.FALSE.booleanValue());
        this.mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, Boolean.TRUE.booleanValue());
        this.mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, Boolean.TRUE.booleanValue());
        this.xmlMapper = new XmlMapper();
        this.xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, Boolean.FALSE.booleanValue());
        this.xmlMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, Boolean.TRUE.booleanValue());
        this.xmlMapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, Boolean.TRUE.booleanValue());
    }

    public String serializationFormat() {
        return "gnip_activity_xml";
    }

    public String serialize(Activity deserialized) {
        throw new UnsupportedOperationException();
    }

    public Activity deserialize(String serializedXML) {
        Activity activity = null;
        try {
            activity = (Activity)this.xmlMapper.readValue((Reader)new StringReader(this.setContentIfEmpty(serializedXML)), Activity.class);
            activity = (Activity)this.mapper.readValue((Reader)new StringReader(this.fixActivityXML(activity, serializedXML)), Activity.class);
        }
        catch (Exception e) {
            LOGGER.error("Exception correcting Gnip Activity Xml to Activity format.", (Throwable)e);
            LOGGER.error("Xml that caused error : {}", (Object)serializedXML);
        }
        return activity;
    }

    public List<Activity> deserializeAll(List<String> serializedList) {
        throw new NotImplementedException("Not currently supported by this deserializer");
    }

    private String fixActivityXML(Activity activity, String xml) throws Exception {
        JSONObject jsonObject = new JSONObject(this.mapper.writeValueAsString((Object)activity));
        JSONObject newObject = (JSONObject)this.fixActivityXML(jsonObject);
        StringReader str = new StringReader(newObject.toString());
        newObject = this.formatFixedJSON(newObject);
        newObject = this.fixDateFormats(newObject, xml);
        newObject = this.createTopLevelConentField(newObject);
        return newObject.toString();
    }

    private Object fixActivityXML(Object obj) throws Exception {
        if (obj instanceof JSONObject) {
            JSONObject json = new JSONObject();
            JSONObject old = (JSONObject)obj;
            Iterator keys = old.keys();
            while (keys.hasNext()) {
                Object o;
                String key = (String)keys.next();
                if (StringUtils.isBlank((String)key)) {
                    return this.fixActivityXML(old.get(key));
                }
                if (key.equals("type") || (o = this.fixActivityXML(old.get(key))) == null) continue;
                json.put(key, o);
            }
            if (json.keys().hasNext()) {
                return json;
            }
            return null;
        }
        return obj;
    }

    private JSONObject formatFixedJSON(JSONObject json) throws Exception {
        String generator;
        JSONObject link;
        JSONObject object;
        JSONObject link2;
        JSONObject actor;
        JSONObject topLink = json.optJSONObject("link");
        if (topLink != null) {
            json.put("link", (Object)topLink.getString("href"));
        }
        if ((actor = json.optJSONObject("actor")) != null && (link2 = actor.optJSONObject("link")) != null) {
            actor.put("link", link2.get("href"));
        }
        if ((object = json.optJSONObject("object")) != null && (link = object.optJSONObject("link")) != null) {
            object.put("link", link.get("href"));
        }
        if ((generator = json.optString("generator")) != null) {
            JSONObject gen = new JSONObject();
            gen.put("displayName", (Object)generator);
            json.put("generator", (Object)gen);
        }
        return json;
    }

    private JSONObject fixDateFormats(JSONObject json, String xml) throws Exception {
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(xml));
        Document doc = docBuilder.parse(is);
        doc.getDocumentElement().normalize();
        if (json.optLong("published", -1L) != -1L) {
            json.put("published", (Object)this.getValueFromXML("published", doc));
        }
        if (json.optLong("updated", -1L) != -1L) {
            json.put("updated", (Object)this.getValueFromXML("updated", doc));
        }
        if (json.optLong("created", -1L) != -1L) {
            json.put("created", (Object)this.getValueFromXML("created", doc));
        }
        return json;
    }

    private JSONObject createTopLevelConentField(JSONObject json) throws JSONException {
        if (!json.isNull("content")) {
            return json;
        }
        JSONObject object = json.optJSONObject("object");
        if (object != null) {
            String content = object.optString("content");
            if (content == null) {
                content = object.optString("summary");
            }
            if (content != null) {
                json.put("content", (Object)content);
            }
        }
        return json;
    }

    private String getValueFromXML(String tag, Document doc) throws Exception {
        Element base = (Element)doc.getElementsByTagName("entry").item(0);
        return base.getElementsByTagName(tag).item(0).getTextContent();
    }

    private String setContentIfEmpty(String xml) throws Exception {
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(xml));
        Document doc = docBuilder.parse(is);
        doc.getDocumentElement().normalize();
        Element base = (Element)doc.getElementsByTagName("entry").item(0);
        NodeList nodeList = base.getChildNodes();
        Element obj = (Element)base.getElementsByTagName("activity:object").item(0);
        Element content = (Element)obj.getElementsByTagName("content").item(0);
        if (content.getTextContent() == null || content.getTextContent().equals("")) {
            content.setTextContent(" ");
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        String output = writer.getBuffer().toString().replaceAll("\n|\r", "");
        return output;
    }
}

