/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.example.test;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigParseOptions;
import java.io.File;
import junit.framework.TestCase;
import org.apache.streams.config.ComponentConfigurator;
import org.apache.streams.elasticsearch.ElasticsearchClientManager;
import org.apache.streams.elasticsearch.ElasticsearchConfiguration;
import org.apache.streams.example.ElasticsearchReindex;
import org.apache.streams.example.ElasticsearchReindexConfiguration;
import org.apache.streams.example.test.ElasticsearchReindexIT;
import org.apache.streams.jackson.StreamsJacksonMapper;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchReindexChildIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchReindexIT.class);
    ObjectMapper MAPPER = StreamsJacksonMapper.getInstance();
    protected ElasticsearchReindexConfiguration testConfiguration;
    protected Client testClient;
    private int count = 0;

    @Before
    public void prepareTest() throws Exception {
        Config reference = ConfigFactory.load();
        File conf_file = new File("target/test-classes/ElasticsearchReindexChildIT.conf");
        assert (conf_file.exists());
        Config testResourceConfig = ConfigFactory.parseFileAnySyntax((File)conf_file, (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false));
        Config typesafe = testResourceConfig.withFallback((ConfigMergeable)reference).resolve();
        this.testConfiguration = (ElasticsearchReindexConfiguration)new ComponentConfigurator(ElasticsearchReindexConfiguration.class).detectConfiguration(typesafe);
        this.testClient = new ElasticsearchClientManager((ElasticsearchConfiguration)this.testConfiguration.getSource()).getClient();
        ClusterHealthRequest clusterHealthRequest = Requests.clusterHealthRequest((String[])new String[0]);
        ClusterHealthResponse clusterHealthResponse = (ClusterHealthResponse)this.testClient.admin().cluster().health(clusterHealthRequest).actionGet();
        Assert.assertNotEquals((Object)clusterHealthResponse.getStatus(), (Object)ClusterHealthStatus.RED);
        IndicesExistsRequest indicesExistsRequest = Requests.indicesExistsRequest((String[])new String[]{(String)this.testConfiguration.getSource().getIndexes().get(0)});
        IndicesExistsResponse indicesExistsResponse = (IndicesExistsResponse)this.testClient.admin().indices().exists(indicesExistsRequest).actionGet();
        TestCase.assertTrue((boolean)indicesExistsResponse.isExists());
        SearchRequestBuilder countRequest = this.testClient.prepareSearch(new String[]{(String)this.testConfiguration.getSource().getIndexes().get(0)}).setTypes(new String[]{(String)this.testConfiguration.getSource().getTypes().get(0)});
        SearchResponse countResponse = (SearchResponse)countRequest.execute().actionGet();
        this.count = (int)countResponse.getHits().getTotalHits();
        Assert.assertNotEquals((long)this.count, (long)0L);
    }

    @Test
    public void testReindex() throws Exception {
        ElasticsearchReindex reindex = new ElasticsearchReindex(this.testConfiguration);
        reindex.run();
        SearchRequestBuilder countRequest = this.testClient.prepareSearch(new String[]{this.testConfiguration.getDestination().getIndex()}).setTypes(new String[]{this.testConfiguration.getDestination().getType()});
        SearchResponse countResponse = (SearchResponse)countRequest.execute().actionGet();
        Assert.assertEquals((long)this.count, (long)((int)countResponse.getHits().getTotalHits()));
    }
}

