/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampipes.processors.imageprocessing.jvm.processor.qrreader;

import boofcv.abst.fiducial.QrCodePreciseDetector;
import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.factory.fiducial.FactoryFiducial;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Optional;
import org.apache.streampipes.commons.exceptions.SpRuntimeException;
import org.apache.streampipes.extensions.api.pe.context.EventProcessorRuntimeContext;
import org.apache.streampipes.extensions.api.pe.routing.SpOutputCollector;
import org.apache.streampipes.model.DataProcessorType;
import org.apache.streampipes.model.graph.DataProcessorDescription;
import org.apache.streampipes.model.output.OutputStrategy;
import org.apache.streampipes.model.runtime.Event;
import org.apache.streampipes.model.schema.EventProperty;
import org.apache.streampipes.model.schema.PropertyScope;
import org.apache.streampipes.processors.imageprocessing.jvm.processor.commons.PlainImageTransformer;
import org.apache.streampipes.sdk.builder.ProcessingElementBuilder;
import org.apache.streampipes.sdk.builder.StreamRequirementsBuilder;
import org.apache.streampipes.sdk.extractor.ProcessingElementParameterExtractor;
import org.apache.streampipes.sdk.helpers.EpProperties;
import org.apache.streampipes.sdk.helpers.EpRequirements;
import org.apache.streampipes.sdk.helpers.Label;
import org.apache.streampipes.sdk.helpers.Labels;
import org.apache.streampipes.sdk.helpers.Locales;
import org.apache.streampipes.sdk.helpers.Options;
import org.apache.streampipes.sdk.helpers.OutputStrategies;
import org.apache.streampipes.wrapper.params.compat.ProcessorParams;
import org.apache.streampipes.wrapper.standalone.StreamPipesDataProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrCodeReaderProcessor
extends StreamPipesDataProcessor {
    private static final String PLACEHOLDER_VALUE = "placeholder-value";
    private static final String SEND_IF_NO_RESULT = "send-if-no-result";
    private static final String QR_VALUE = "qr-value";
    private static final Logger LOG = LoggerFactory.getLogger(QrCodeReaderProcessor.class);
    private String imagePropertyName;
    private String placeholderValue;
    private Boolean sendIfNoResult;

    public DataProcessorDescription declareModel() {
        return (DataProcessorDescription)((ProcessingElementBuilder)((ProcessingElementBuilder)((ProcessingElementBuilder)((ProcessingElementBuilder)((ProcessingElementBuilder)ProcessingElementBuilder.create((String)"org.apache.streampipes.processor.imageclassification.qrcode").category(new DataProcessorType[]{DataProcessorType.IMAGE_PROCESSING}).withAssets(new String[]{"documentation.md", "icon.png"})).withLocales(new Locales[]{Locales.EN})).requiredStream(StreamRequirementsBuilder.create().requiredPropertyWithUnaryMapping((EventProperty)EpRequirements.domainPropertyReq((String)"https://image.com"), Labels.withId((String)"image-property"), PropertyScope.NONE).build())).requiredSingleValueSelection(Labels.withId((String)SEND_IF_NO_RESULT), Options.from((String[])new String[]{"Yes", "No"}))).requiredTextParameter(Labels.withId((String)PLACEHOLDER_VALUE))).outputStrategy((OutputStrategy)OutputStrategies.fixed((EventProperty[])new EventProperty[]{EpProperties.timestampProperty((String)"timestamp"), EpProperties.stringEp((Label)Labels.withId((String)QR_VALUE), (String)"qrvalue", (String)"http://schema.org/text")})).build();
    }

    public void onInvocation(ProcessorParams parameters, SpOutputCollector spOutputCollector, EventProcessorRuntimeContext runtimeContext) throws SpRuntimeException {
        ProcessingElementParameterExtractor extractor = parameters.extractor();
        this.imagePropertyName = extractor.mappingPropertyValue("image-property");
        this.placeholderValue = (String)extractor.singleValueParameter(PLACEHOLDER_VALUE, String.class);
        this.sendIfNoResult = ((String)extractor.selectedSingleValue(SEND_IF_NO_RESULT, String.class)).equals("Yes");
    }

    public void onEvent(Event in, SpOutputCollector out) throws SpRuntimeException {
        PlainImageTransformer imageTransformer = new PlainImageTransformer(in);
        Optional<BufferedImage> imageOpt = imageTransformer.getImage(this.imagePropertyName);
        if (imageOpt.isPresent()) {
            BufferedImage input = imageOpt.get();
            GrayU8 gray = ConvertBufferedImage.convertFrom((BufferedImage)input, (GrayU8)null);
            QrCodePreciseDetector detector = FactoryFiducial.qrcode(null, GrayU8.class);
            detector.process((ImageGray)gray);
            List detections = detector.getDetections();
            List failures = detector.getFailures();
            if (detections.size() > 0) {
                LOG.info(((QrCode)detections.get((int)0)).message);
                Event event = this.makeEvent(((QrCode)detections.get((int)0)).message);
                out.collect(event);
            } else {
                LOG.info("Could not find any QR code");
                if (this.sendIfNoResult.booleanValue()) {
                    Event event = this.makeEvent(this.placeholderValue);
                    out.collect(event);
                }
            }
        }
    }

    private Event makeEvent(String qrCodeValue) {
        Event event = new Event();
        event.addField("qrvalue", qrCodeValue);
        event.addField("timestamp", Long.valueOf(System.currentTimeMillis()));
        return event;
    }

    public void onDetach() throws SpRuntimeException {
    }
}

