/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampipes.processors.imageprocessing.jvm.processor.imageenrichment;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.streampipes.commons.exceptions.SpRuntimeException;
import org.apache.streampipes.extensions.api.pe.context.EventProcessorRuntimeContext;
import org.apache.streampipes.extensions.api.pe.routing.SpOutputCollector;
import org.apache.streampipes.model.DataProcessorType;
import org.apache.streampipes.model.graph.DataProcessorDescription;
import org.apache.streampipes.model.output.OutputStrategy;
import org.apache.streampipes.model.runtime.Event;
import org.apache.streampipes.model.schema.EventProperty;
import org.apache.streampipes.processors.imageprocessing.jvm.processor.commons.ImagePropertyConstants;
import org.apache.streampipes.processors.imageprocessing.jvm.processor.commons.ImageTransformer;
import org.apache.streampipes.processors.imageprocessing.jvm.processor.commons.RequiredBoxStream;
import org.apache.streampipes.processors.imageprocessing.jvm.processor.imageenrichment.BoxCoordinates;
import org.apache.streampipes.processors.imageprocessing.jvm.processor.imageenrichment.ColorUtil;
import org.apache.streampipes.sdk.builder.ProcessingElementBuilder;
import org.apache.streampipes.sdk.extractor.ProcessingElementParameterExtractor;
import org.apache.streampipes.sdk.helpers.EpProperties;
import org.apache.streampipes.sdk.helpers.Label;
import org.apache.streampipes.sdk.helpers.Labels;
import org.apache.streampipes.sdk.helpers.Locales;
import org.apache.streampipes.sdk.helpers.OutputStrategies;
import org.apache.streampipes.wrapper.params.compat.ProcessorParams;
import org.apache.streampipes.wrapper.standalone.StreamPipesDataProcessor;

public class ImageEnrichmentProcessor
extends StreamPipesDataProcessor {
    private String imageProperty;
    private String boxArray;

    public DataProcessorDescription declareModel() {
        return (DataProcessorDescription)((ProcessingElementBuilder)((ProcessingElementBuilder)((ProcessingElementBuilder)ProcessingElementBuilder.create((String)"org.apache.streampipes.processor.imageclassification.jvm.image-enricher").withAssets(new String[]{"documentation.md", "icon.png"})).withLocales(new Locales[]{Locales.EN})).category(new DataProcessorType[]{DataProcessorType.IMAGE_PROCESSING}).requiredStream(RequiredBoxStream.getBoxStream())).outputStrategy((OutputStrategy)OutputStrategies.fixed((EventProperty[])new EventProperty[]{EpProperties.stringEp((Label)Labels.empty(), (String)ImagePropertyConstants.IMAGE.getProperty(), (String)"https://image.com")})).build();
    }

    public void onInvocation(ProcessorParams parameters, SpOutputCollector spOutputCollector, EventProcessorRuntimeContext runtimeContext) throws SpRuntimeException {
        ProcessingElementParameterExtractor extractor = parameters.extractor();
        this.imageProperty = extractor.mappingPropertyValue("image-property");
        this.boxArray = extractor.mappingPropertyValue("box-array-property");
    }

    public void onEvent(Event in, SpOutputCollector out) throws SpRuntimeException {
        ImageTransformer imageTransformer = new ImageTransformer(in);
        Optional<BufferedImage> imageOpt = imageTransformer.getImage(this.imageProperty);
        if (imageOpt.isPresent()) {
            BufferedImage image = imageOpt.get();
            List<Map<String, Object>> allBoxesMap = imageTransformer.getAllBoxCoordinates(this.boxArray);
            for (Map<String, Object> box : allBoxesMap) {
                BoxCoordinates boxCoordinates = imageTransformer.getBoxCoordinatesWithAnnotations(image, box);
                Graphics2D graph = image.createGraphics();
                Color color = ColorUtil.getColor(boxCoordinates.getClassesindex().hashCode());
                graph.setColor(color);
                graph.setStroke(new BasicStroke(5.0f));
                graph.draw(new Rectangle(boxCoordinates.getX(), boxCoordinates.getY(), boxCoordinates.getWidth(), boxCoordinates.getHeight()));
                String str = boxCoordinates.getClassesindex() + ": " + boxCoordinates.getScore();
                FontMetrics fm = graph.getFontMetrics();
                Rectangle2D rect = fm.getStringBounds(str, graph);
                graph.fillRect(boxCoordinates.getX(), boxCoordinates.getY() - fm.getAscent(), (int)rect.getWidth(), (int)rect.getHeight());
                graph.setColor(Color.white);
                graph.drawString(str, boxCoordinates.getX(), boxCoordinates.getY());
                graph.dispose();
            }
            Optional<byte[]> finalImage = imageTransformer.makeImage(image);
            if (finalImage.isPresent()) {
                Event outEvent = new Event();
                outEvent.addField(ImagePropertyConstants.IMAGE.getProperty(), Base64.getEncoder().encodeToString(finalImage.get()));
                out.collect(outEvent);
            }
        }
    }

    public void onDetach() throws SpRuntimeException {
    }
}

