/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampipes.processors.imageprocessing.jvm.processor.imagecropper;

import java.awt.image.BufferedImage;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.streampipes.commons.exceptions.SpRuntimeException;
import org.apache.streampipes.extensions.api.pe.context.EventProcessorRuntimeContext;
import org.apache.streampipes.extensions.api.pe.routing.SpOutputCollector;
import org.apache.streampipes.model.DataProcessorType;
import org.apache.streampipes.model.graph.DataProcessorDescription;
import org.apache.streampipes.model.output.OutputStrategy;
import org.apache.streampipes.model.runtime.Event;
import org.apache.streampipes.model.schema.EventProperty;
import org.apache.streampipes.processors.imageprocessing.jvm.processor.commons.ImagePropertyConstants;
import org.apache.streampipes.processors.imageprocessing.jvm.processor.commons.ImageTransformer;
import org.apache.streampipes.processors.imageprocessing.jvm.processor.commons.RequiredBoxStream;
import org.apache.streampipes.processors.imageprocessing.jvm.processor.imageenrichment.BoxCoordinates;
import org.apache.streampipes.sdk.builder.ProcessingElementBuilder;
import org.apache.streampipes.sdk.extractor.ProcessingElementParameterExtractor;
import org.apache.streampipes.sdk.helpers.EpProperties;
import org.apache.streampipes.sdk.helpers.Label;
import org.apache.streampipes.sdk.helpers.Labels;
import org.apache.streampipes.sdk.helpers.Locales;
import org.apache.streampipes.sdk.helpers.OutputStrategies;
import org.apache.streampipes.wrapper.params.compat.ProcessorParams;
import org.apache.streampipes.wrapper.standalone.StreamPipesDataProcessor;

public class ImageCropperProcessor
extends StreamPipesDataProcessor {
    private String imageProperty;
    private String boxArray;

    public DataProcessorDescription declareModel() {
        return (DataProcessorDescription)((ProcessingElementBuilder)((ProcessingElementBuilder)((ProcessingElementBuilder)ProcessingElementBuilder.create((String)"org.apache.streampipes.processor.imageclassification.jvm.image-cropper").withAssets(new String[]{"documentation.md", "icon.png"})).withLocales(new Locales[]{Locales.EN})).category(new DataProcessorType[]{DataProcessorType.IMAGE_PROCESSING}).requiredStream(RequiredBoxStream.getBoxStream())).outputStrategy((OutputStrategy)OutputStrategies.append((EventProperty[])new EventProperty[]{EpProperties.integerEp((Label)Labels.empty(), (String)ImagePropertyConstants.CLASS_NAME.getProperty(), (String)"https://streampipes.org/classname"), EpProperties.doubleEp((Label)Labels.empty(), (String)ImagePropertyConstants.SCORE.getProperty(), (String)"https://streampipes.org/Label")})).build();
    }

    public void onInvocation(ProcessorParams parameters, SpOutputCollector spOutputCollector, EventProcessorRuntimeContext runtimeContext) {
        ProcessingElementParameterExtractor extractor = parameters.extractor();
        this.imageProperty = extractor.mappingPropertyValue("image-property");
        this.boxArray = extractor.mappingPropertyValue("box-array-property");
    }

    public void onEvent(Event in, SpOutputCollector out) throws SpRuntimeException {
        ImageTransformer imageTransformer = new ImageTransformer(in);
        Optional<BufferedImage> imageOpt = imageTransformer.getImage(this.imageProperty);
        if (imageOpt.isPresent()) {
            BufferedImage image = imageOpt.get();
            List<Map<String, Object>> allBoxCoordinates = imageTransformer.getAllBoxCoordinates(this.boxArray);
            for (Map<String, Object> box : allBoxCoordinates) {
                BoxCoordinates boxCoordinates = imageTransformer.getBoxCoordinates(image, box);
                BufferedImage dest = image.getSubimage(boxCoordinates.getX(), boxCoordinates.getY(), boxCoordinates.getWidth(), boxCoordinates.getHeight());
                Optional<byte[]> finalImage = imageTransformer.makeImage(dest);
                if (!finalImage.isPresent()) continue;
                Event outEvent = new Event();
                outEvent.addField(ImagePropertyConstants.TIMESTAMP.getProperty(), in.getFieldByRuntimeName(ImagePropertyConstants.TIMESTAMP.getProperty()).getAsPrimitive().getAsLong());
                outEvent.addField(ImagePropertyConstants.IMAGE.getProperty(), Base64.getEncoder().encodeToString(finalImage.get()));
                outEvent.addField(ImagePropertyConstants.CLASS_NAME.getProperty(), box.get(ImagePropertyConstants.CLASS_NAME.getProperty()));
                outEvent.addField(ImagePropertyConstants.SCORE.getProperty(), box.get(ImagePropertyConstants.SCORE.getProperty()));
                out.collect(outEvent);
            }
        }
    }

    public void onDetach() throws SpRuntimeException {
    }
}

